/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package de.gesellix.docker.remote.api

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

/**
 * Defines how the volume is used by tasks.
 *
 * @param scope The set of nodes this volume can be used on at one time. - `single` The volume may only be scheduled to one node at a time. - `multi` the volume may be scheduled to any supported number of nodes at a time.
 * @param sharing The number and way that different tasks can use this volume at one time. - `none` The volume may only be used by one task at a time. - `readonly` The volume may be used by any number of tasks, but they all must mount the volume as readonly - `onewriter` The volume may be used by any number of tasks, but only one may mount it as read/write. - `all` The volume may have any number of readers and writers.
 * @param mountVolume Options for using this volume as a Mount-type volume.      Either MountVolume or BlockVolume, but not both, must be     present.   properties:     FsType:       type: \"string\"       description: |         Specifies the filesystem type for the mount volume.         Optional.     MountFlags:       type: \"array\"       description: |         Flags to pass when mounting the volume. Optional.       items:         type: \"string\" BlockVolume:   type: \"object\"   description: |     Options for using this volume as a Block-type volume.     Intentionally empty.
 * @param secrets Swarm Secrets that are passed to the CSI storage plugin when operating on this volume.
 * @param accessibilityRequirements
 * @param capacityRange
 * @param availability The availability of the volume for use in tasks. - `active` The volume is fully available for scheduling on the cluster - `pause` No new workloads should use the volume, but existing workloads are not stopped. - `drain` All workloads using this volume should be stopped and rescheduled, and no new ones should be started.
 */
@JsonClass(generateAdapter = true)
data class ClusterVolumeSpecAccessMode(
    // The set of nodes this volume can be used on at one time. - `single` The volume may only be scheduled to one node at a time. - `multi` the volume may be scheduled to any supported number of nodes at a time.
    @Json(name = "Scope")
    var scope: ClusterVolumeSpecAccessMode.Scope? = Scope.Single,
    // The number and way that different tasks can use this volume at one time. - `none` The volume may only be used by one task at a time. - `readonly` The volume may be used by any number of tasks, but they all must mount the volume as readonly - `onewriter` The volume may be used by any number of tasks, but only one may mount it as read/write. - `all` The volume may have any number of readers and writers.
    @Json(name = "Sharing")
    var sharing: ClusterVolumeSpecAccessMode.Sharing? = Sharing.None,
    // Options for using this volume as a Mount-type volume.      Either MountVolume or BlockVolume, but not both, must be     present.   properties:     FsType:       type: \"string\"       description: |         Specifies the filesystem type for the mount volume.         Optional.     MountFlags:       type: \"array\"       description: |         Flags to pass when mounting the volume. Optional.       items:         type: \"string\" BlockVolume:   type: \"object\"   description: |     Options for using this volume as a Block-type volume.     Intentionally empty.
    @Json(name = "MountVolume")
    var mountVolume: kotlin.Any? = null,
    // Swarm Secrets that are passed to the CSI storage plugin when operating on this volume.
    @Json(name = "Secrets")
    var secrets: kotlin.collections.MutableList<ClusterVolumeSpecAccessModeSecretsInner>? = null,
    @Json(name = "AccessibilityRequirements")
    var accessibilityRequirements: ClusterVolumeSpecAccessModeAccessibilityRequirements? = null,
    @Json(name = "CapacityRange")
    var capacityRange: ClusterVolumeSpecAccessModeCapacityRange? = null,
    // The availability of the volume for use in tasks. - `active` The volume is fully available for scheduling on the cluster - `pause` No new workloads should use the volume, but existing workloads are not stopped. - `drain` All workloads using this volume should be stopped and rescheduled, and no new ones should be started.
    @Json(name = "Availability")
    var availability: ClusterVolumeSpecAccessMode.Availability? = Availability.Active,
) {
    /**
     * The set of nodes this volume can be used on at one time. - `single` The volume may only be scheduled to one node at a time. - `multi` the volume may be scheduled to any supported number of nodes at a time.
     *
     * Values: Single,Multi
     */
    @JsonClass(generateAdapter = false)
    enum class Scope(val value: kotlin.String) {
        @Json(name = "single")
        Single("single"),

        @Json(name = "multi")
        Multi("multi"),
    }

    /**
     * The number and way that different tasks can use this volume at one time. - `none` The volume may only be used by one task at a time. - `readonly` The volume may be used by any number of tasks, but they all must mount the volume as readonly - `onewriter` The volume may be used by any number of tasks, but only one may mount it as read/write. - `all` The volume may have any number of readers and writers.
     *
     * Values: None,Readonly,Onewriter,All
     */
    @JsonClass(generateAdapter = false)
    enum class Sharing(val value: kotlin.String) {
        @Json(name = "none")
        None("none"),

        @Json(name = "readonly")
        Readonly("readonly"),

        @Json(name = "onewriter")
        Onewriter("onewriter"),

        @Json(name = "all")
        All("all"),
    }

    /**
     * The availability of the volume for use in tasks. - `active` The volume is fully available for scheduling on the cluster - `pause` No new workloads should use the volume, but existing workloads are not stopped. - `drain` All workloads using this volume should be stopped and rescheduled, and no new ones should be started.
     *
     * Values: Active,Pause,Drain
     */
    @JsonClass(generateAdapter = false)
    enum class Availability(val value: kotlin.String) {
        @Json(name = "active")
        Active("active"),

        @Json(name = "pause")
        Pause("pause"),

        @Json(name = "drain")
        Drain("drain"),
    }
}
