/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package de.gesellix.docker.remote.api

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

/**
 *
 *
 * @param nodeID The ID of the Swarm node the volume is published on.
 * @param state The published state of the volume. * `pending-publish` The volume should be published to this node, but the call to the controller plugin to do so has not yet been successfully completed. * `published` The volume is published successfully to the node. * `pending-node-unpublish` The volume should be unpublished from the node, and the manager is awaiting confirmation from the worker that it has done so. * `pending-controller-unpublish` The volume is successfully unpublished from the node, but has not yet been successfully unpublished on the controller.
 * @param publishContext A map of strings to strings returned by the CSI controller plugin when a volume is published.
 */
@JsonClass(generateAdapter = true)
data class ClusterVolumePublishStatusInner(
    // The ID of the Swarm node the volume is published on.
    @Json(name = "NodeID")
    var nodeID: kotlin.String? = null,
    // The published state of the volume. * `pending-publish` The volume should be published to this node, but the call to the controller plugin to do so has not yet been successfully completed. * `published` The volume is published successfully to the node. * `pending-node-unpublish` The volume should be unpublished from the node, and the manager is awaiting confirmation from the worker that it has done so. * `pending-controller-unpublish` The volume is successfully unpublished from the node, but has not yet been successfully unpublished on the controller.
    @Json(name = "State")
    var state: ClusterVolumePublishStatusInner.State? = null,
    // A map of strings to strings returned by the CSI controller plugin when a volume is published.
    @Json(name = "PublishContext")
    var publishContext: kotlin.collections.MutableMap<kotlin.String, kotlin.String>? = null,
) {
    /**
     * The published state of the volume. * `pending-publish` The volume should be published to this node, but the call to the controller plugin to do so has not yet been successfully completed. * `published` The volume is published successfully to the node. * `pending-node-unpublish` The volume should be unpublished from the node, and the manager is awaiting confirmation from the worker that it has done so. * `pending-controller-unpublish` The volume is successfully unpublished from the node, but has not yet been successfully unpublished on the controller.
     *
     * Values: PendingPublish,Published,PendingNodeUnpublish,PendingControllerUnpublish
     */
    @JsonClass(generateAdapter = false)
    enum class State(val value: kotlin.String) {
        @Json(name = "pending-publish")
        PendingPublish("pending-publish"),

        @Json(name = "published")
        Published("published"),

        @Json(name = "pending-node-unpublish")
        PendingNodeUnpublish("pending-node-unpublish"),

        @Json(name = "pending-controller-unpublish")
        PendingControllerUnpublish("pending-controller-unpublish"),
    }
}
