/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.registry;

import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.registry.LocalDocker;
import de.gesellix.docker.remote.api.ContainerCreateRequest;
import de.gesellix.docker.remote.api.ContainerCreateResponse;
import de.gesellix.docker.remote.api.ContainerInspectResponse;
import de.gesellix.docker.remote.api.HostConfig;
import de.gesellix.docker.remote.api.PortBinding;
import de.gesellix.docker.remote.api.client.ContainerApi;
import de.gesellix.docker.remote.api.client.ImageApi;
import de.gesellix.docker.remote.api.core.ClientException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRegistry {
    private static final Logger log = LoggerFactory.getLogger(DockerRegistry.class);
    private final ContainerApi containerApi;
    private final ImageApi imageApi;
    private String imageNameWithTag;
    private String registryId;

    public DockerRegistry() {
        DockerClientConfig dockerClientConfig = new DockerClientConfig();
        this.containerApi = new ContainerApi(dockerClientConfig);
        this.imageApi = new ImageApi(dockerClientConfig);
        this.imageNameWithTag = LocalDocker.isNativeWindows() ? "gesellix/registry:3.0.0-windows-ltsc2022" : "registry:3.0.0";
        this.imageNameWithTag = System.getProperty("DOCKER_REGISTRY_IMAGE_OVERRIDE", this.imageNameWithTag);
    }

    public void setImageNameWithTag(String imageNameWithTag) {
        this.imageNameWithTag = imageNameWithTag;
    }

    public String getImageNameWithTag() {
        return this.imageNameWithTag;
    }

    public void run() {
        ContainerCreateRequest containerConfig = new ContainerCreateRequest();
        containerConfig.setImage(this.getImageNameWithTag());
        containerConfig.setEnv(Collections.singletonList("REGISTRY_VALIDATION_DISABLED=true"));
        HashMap exposedPorts = new HashMap();
        exposedPorts.put("5000/tcp", Collections.emptyMap());
        containerConfig.setExposedPorts(exposedPorts);
        HostConfig hostConfig = new HostConfig();
        hostConfig.setPublishAllPorts(Boolean.valueOf(true));
        containerConfig.setHostConfig(hostConfig);
        ContainerCreateResponse registryStatus = this.run(containerConfig);
        this.registryId = registryStatus.getId();
    }

    ContainerCreateResponse run(ContainerCreateRequest containerCreateRequest) {
        log.info("docker run {}", (Object)containerCreateRequest.getImage());
        ContainerCreateResponse createContainerResponse = this.createContainer(containerCreateRequest);
        log.debug("create container result: {}", (Object)createContainerResponse);
        String containerId = createContainerResponse.getId();
        this.containerApi.containerStart(containerId, null);
        return createContainerResponse;
    }

    ContainerCreateResponse createContainer(ContainerCreateRequest containerCreateRequest) {
        log.debug("docker create");
        try {
            return this.containerApi.containerCreate(containerCreateRequest, null);
        }
        catch (ClientException exception) {
            if (exception.getStatusCode() == 404) {
                log.debug("Image '{}' not found locally.", (Object)containerCreateRequest.getImage());
                this.imageApi.imageCreate(containerCreateRequest.getImage(), null, null, null, null, null, null, null, null);
                return this.containerApi.containerCreate(containerCreateRequest, null);
            }
            throw exception;
        }
    }

    public String address() {
        return "localhost";
    }

    public int port() {
        ContainerInspectResponse registryContainer = this.containerApi.containerInspect(this.registryId, null);
        List portBinding = (List)registryContainer.getNetworkSettings().getPorts().get("5000/tcp");
        PortBinding firstPortBinding = (PortBinding)portBinding.stream().findFirst().orElseThrow(() -> new RuntimeException("No PortBinding for port 5000/tcp"));
        if (firstPortBinding.getHostPort() == null) {
            throw new RuntimeException("Null PortBinding for port 5000/tcp");
        }
        return Integer.parseInt(firstPortBinding.getHostPort());
    }

    public String url() {
        return this.address() + ":" + this.port();
    }

    public void rm() {
        this.containerApi.containerStop(this.registryId, null);
        this.containerApi.containerWait(this.registryId, (ContainerApi.ConditionContainerWait)null);
        this.containerApi.containerDelete(this.registryId, null, null, null);
    }
}

