/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.examples;

import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.StaticIteratorETL;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.etls.transformers.AbstractIteratorTransformer;
import de.gerdiproject.json.datacite.DataCiteJson;
import de.gerdiproject.json.datacite.Title;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MockedETL
extends StaticIteratorETL<String, DataCiteJson> {
    protected final List<String> mockedEntries;

    public MockedETL() {
        this(Arrays.asList("mockedEntry1", "mockedEntry2", "mockedEntry3"));
    }

    public MockedETL(List<String> mockedEntries) {
        super((AbstractIteratorExtractor)new MockedExtractor(), (AbstractIteratorTransformer)new MockedTransformer());
        this.mockedEntries = mockedEntries;
    }

    public String getId() {
        return this.getName();
    }

    public void setHash(String sourceHash) {
        this.hash = sourceHash;
    }

    private static class MockedTransformer
    extends AbstractIteratorTransformer<String, DataCiteJson> {
        private MockedTransformer() {
        }

        protected DataCiteJson transformElement(String source) {
            DataCiteJson mockedDocument = new DataCiteJson("source: " + source);
            mockedDocument.addTitles(Arrays.asList(new Title("title: " + source)));
            return mockedDocument;
        }

        public void init(AbstractETL<?, ?> etl) {
        }

        public void clear() {
        }
    }

    private static class MockedExtractor
    extends AbstractIteratorExtractor<String> {
        private List<String> mockedList = Arrays.asList("mockedEntry1", "mockedEntry2", "mockedEntry3");

        private MockedExtractor() {
        }

        public Iterator<String> extract() {
            return this.mockedList.iterator();
        }

        public String getUniqueVersionString() {
            return null;
        }

        public int size() {
            return this.mockedList.size();
        }

        protected Iterator<String> extractAll() {
            return this.mockedList.iterator();
        }

        public void clear() {
        }
    }
}

