/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.utils.logger.HarvesterLog;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvesterLogTest
extends AbstractObjectUnitTest<HarvesterLog> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HarvesterLogTest.class);
    private static final String EXAMPLE_LOG = "This log is created by the HarvesterLog unit tests.";
    private final File logFile = new File(this.getTemporaryTestDirectory(), "test.log");

    @Override
    protected HarvesterLog setUpTestObjects() {
        System.out.close();
        HarvesterLog log = new HarvesterLog(this.logFile.getPath());
        log.registerLogger();
        return log;
    }

    @Override
    protected boolean isLoggingEnabledDuringTests() {
        return true;
    }

    @Override
    public void after() {
        ((HarvesterLog)this.testedObject).unregisterLogger();
        this.setLoggerEnabled(false);
        ((HarvesterLog)this.testedObject).clearLog();
        this.setLoggerEnabled(this.isLoggingEnabledDuringTests());
        super.after();
    }

    @Test
    public void testLogFileCreation() {
        Assert.assertTrue((String)("The method registerLogger() should cause the log file " + this.logFile + " to be created!"), (this.logFile.exists() && this.logFile.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testLogging() {
        long logSizeBefore = this.logFile.length();
        LOGGER.info(EXAMPLE_LOG);
        long logSizeAfter = this.logFile.length();
        Assert.assertNotEquals((String)"Logging something after registerLogger() is called should cause the log file to change!", (long)logSizeBefore, (long)logSizeAfter);
    }

    @Test
    public void testLoggingWhileUnRegistered() {
        LOGGER.info(EXAMPLE_LOG);
        long logSizeBeforeUnregister = this.logFile.length();
        ((HarvesterLog)this.testedObject).unregisterLogger();
        LOGGER.info(EXAMPLE_LOG);
        long logSizeAfterUnregister = this.logFile.length();
        Assert.assertEquals((String)"Logging something after unregisterLogger() is called should cause no changes in the log file!", (long)logSizeBeforeUnregister, (long)logSizeAfterUnregister);
    }

    @Test
    public void testLoggingAfterReRegistering() {
        ((HarvesterLog)this.testedObject).unregisterLogger();
        ((HarvesterLog)this.testedObject).registerLogger();
        LOGGER.info(EXAMPLE_LOG);
        Assert.assertNotEquals((String)"Logging something after an unregistered logger is registered again should cause the log file to change!", (long)0L, (long)this.logFile.length());
    }

    @Test
    public void testLogFileClear() {
        LOGGER.info(EXAMPLE_LOG);
        ((HarvesterLog)this.testedObject).unregisterLogger();
        ((HarvesterLog)this.testedObject).clearLog();
        Assert.assertEquals((String)"Calling clearLog() should cause the log file to become empty!", (long)0L, (long)this.logFile.length());
    }
}

