/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import com.google.gson.Gson;
import de.gerdiproject.harvest.AbstractUnitTest;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest
extends AbstractUnitTest {
    private static final String DUPLICATE_DIR_ERROR = "Creating directories that already exist, should not cause exceptions";
    private static final String DELETE_DIR_ERROR = "Deleting non-existing directories, should not cause exceptions";
    private static final String DELETE_FILE_ERROR = "Deleting non-existing files, should not cause exceptions";
    private final File fileTestFolder = this.getTemporaryTestDirectory();
    private final File multiTestDir = new File(this.fileTestFolder, "moarTests/moar");
    private final File testFile = new File(this.fileTestFolder, "fileUtilsTest.file");
    private final File copyTestSourceDir = new File(this.fileTestFolder, "copyTestFrom/aaa/");
    private final File copyTestTargetDir = new File(this.fileTestFolder, "copyTestTo/bbb/");
    private final File copyTestSourceFile = new File(this.copyTestSourceDir, "fileUtilsCopyTestSource.file");
    private final File copyTestTargetFile = new File(this.copyTestTargetDir, "fileUtilsCopyTestTarget.file");
    private final String copyTestText = "Milch macht m\u00fcde M\u00e4nner munter.";
    private final String copyTestOverwriteText = "Ohne Krimi geht die Mimi nie ins Bett.";
    private final File mergeTestSourceDir = new File(this.fileTestFolder, "mergeTestFrom");
    private final File mergeTestTargetDir = new File(this.fileTestFolder, "mergeTestTo");
    private final List<File> mergeTestSourceFiles = Collections.unmodifiableList(Arrays.asList(new File(this.fileTestFolder, "mergeTestFrom/aaa/first.file"), new File(this.fileTestFolder, "mergeTestFrom/ccc/fifth.file"), new File(this.fileTestFolder, "mergeTestFrom/ccc/sixth.file")));
    private final List<File> mergeTestMergedSourceFiles = Collections.unmodifiableList(Arrays.asList(new File(this.fileTestFolder, "mergeTestTo/aaa/first.file"), new File(this.fileTestFolder, "mergeTestTo/ccc/fifth.file"), new File(this.fileTestFolder, "mergeTestTo/ccc/sixth.file")));
    private final List<File> mergeTestTargetFiles = Collections.unmodifiableList(Arrays.asList(new File(this.fileTestFolder, "mergeTestTo/aaa/first.file"), new File(this.fileTestFolder, "mergeTestTo/aaa/second.file"), new File(this.fileTestFolder, "mergeTestTo/bbb/third.file"), new File(this.fileTestFolder, "mergeTestTo/bbb/fourth.file")));
    private final List<File> mergeTestExpectedTargetFiles = Collections.unmodifiableList(Arrays.asList(new File(this.fileTestFolder, "mergeTestTo/aaa/first.file"), new File(this.fileTestFolder, "mergeTestTo/aaa/second.file"), new File(this.fileTestFolder, "mergeTestTo/bbb/third.file"), new File(this.fileTestFolder, "mergeTestTo/bbb/fourth.file"), new File(this.fileTestFolder, "mergeTestTo/ccc/fifth.file"), new File(this.fileTestFolder, "mergeTestTo/ccc/sixth.file")));

    @Test
    public void testFileCreation() {
        FileUtils.createEmptyFile((File)this.testFile);
        Assert.assertTrue((String)"The method createEmptyFile() should create an empty file, duh!", (this.testFile.exists() && this.testFile.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testFileCreationExisting() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.testFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        FileUtils.createEmptyFile((File)this.testFile);
        Assert.assertEquals((String)"The method createEmptyFile() should overwrite existing files!", (long)0L, (long)this.testFile.length());
    }

    @Test
    public void testFileDeletion() {
        FileUtils.createEmptyFile((File)this.testFile);
        FileUtils.deleteFile((File)this.testFile);
        Assert.assertFalse((String)"The method deleteFile() should remove files from the file system!", (boolean)this.testFile.exists());
    }

    @Test
    public void testFileDeletionNonExisting() {
        try {
            FileUtils.deleteFile((File)this.testFile);
        }
        catch (Exception e) {
            Assert.fail((String)DELETE_FILE_ERROR);
        }
    }

    @Test
    public void testFileCopyingWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        FileUtils.copyFile((File)this.copyTestSourceFile, (File)this.copyTestTargetFile);
        Assert.assertEquals((String)"The method copyFile() should create new files if the target destination does not exist!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(this.copyTestTargetFile));
    }

    @Test
    public void testFileCopyingWithoutSource() {
        FileUtils.copyFile((File)this.copyTestSourceFile, (File)this.copyTestTargetFile);
        Assert.assertFalse((String)"The method copyFile() should not create files if the source file does not exist!", (boolean)this.copyTestTargetFile.exists());
    }

    @Test
    public void testFileCopyingWithTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(this.copyTestTargetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.copyFile((File)this.copyTestSourceFile, (File)this.copyTestTargetFile);
        Assert.assertEquals((String)"The method copyFile() should overwrite existing target files!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(this.copyTestTargetFile));
    }

    @Test
    public void testIfFileReplacementRemovesSourceFile() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(this.copyTestTargetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.replaceFile((File)this.copyTestTargetFile, (File)this.copyTestSourceFile);
        Assert.assertFalse((String)"The method replaceFile() should remove the source file!", (boolean)this.copyTestSourceFile.exists());
    }

    @Test
    public void testFileReplacementReplacesTargetFile() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(this.copyTestTargetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.replaceFile((File)this.copyTestTargetFile, (File)this.copyTestSourceFile);
        Assert.assertEquals((String)"The method replaceFile() should overwrite existing target files!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(this.copyTestTargetFile));
    }

    @Test
    public void testFileReplacementRemovesBackupFile() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(this.copyTestTargetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.replaceFile((File)this.copyTestTargetFile, (File)this.copyTestSourceFile);
        Assert.assertFalse((String)"The method replaceFile() should remove the backup files created during execution of the method!", (boolean)new File(this.copyTestTargetFile.getPath() + ".tmp").exists());
    }

    @Test
    public void testFileReplacementWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        FileUtils.replaceFile((File)this.copyTestTargetFile, (File)this.copyTestSourceFile);
        Assert.assertEquals((String)"The method replaceFile() should create target files if they are missing!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(this.copyTestTargetFile));
    }

    @Test
    public void testFileReplacementWithoutSource() {
        FileUtils.replaceFile((File)this.copyTestTargetFile, (File)this.copyTestSourceFile);
        Assert.assertFalse((String)"The method replaceFile() should not alter the file system if the source file is missing!", (boolean)this.copyTestTargetFile.exists());
    }

    @Test
    public void testDirectoryCreation() {
        FileUtils.createDirectories((File)this.multiTestDir);
        Assert.assertTrue((String)"The method createDirectories() should create directories!", (this.multiTestDir.exists() && this.multiTestDir.isDirectory() ? 1 : 0) != 0);
    }

    @Test
    public void testDirectoryCreationExisting() {
        FileUtils.createDirectories((File)this.multiTestDir);
        try {
            FileUtils.createDirectories((File)this.multiTestDir);
        }
        catch (Exception e) {
            Assert.fail((String)DUPLICATE_DIR_ERROR);
        }
    }

    @Test
    public void testDirectoryDeletion() {
        FileUtils.createDirectories((File)this.multiTestDir);
        File tempDir = this.getTemporaryTestDirectory();
        FileUtils.deleteFile((File)tempDir);
        Assert.assertFalse((String)"The method deleteFile() should delete directories!", (boolean)tempDir.exists());
    }

    @Test
    public void testDirectoryDeletionNonExisting() {
        try {
            FileUtils.deleteFile((File)this.getTemporaryTestDirectory());
        }
        catch (Exception e) {
            Assert.fail((String)DELETE_DIR_ERROR);
        }
    }

    @Test
    public void testDirectoryCopyingWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        FileUtils.copyFile((File)this.copyTestSourceDir, (File)this.copyTestTargetDir);
        File targetFile = new File(this.copyTestTargetDir, this.copyTestSourceFile.getName());
        Assert.assertEquals((String)"The method copyFile() should create target directories if they are missing!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryCopyingWithoutSource() {
        FileUtils.copyFile((File)this.copyTestSourceDir, (File)this.copyTestTargetDir);
        Assert.assertFalse((String)"The method copyFile() should not create directories if there are no source directories!", (boolean)this.copyTestTargetDir.exists());
    }

    @Test
    public void testDirectoryCopyingWithTarget() {
        File targetFile = new File(this.copyTestTargetDir, this.copyTestSourceFile.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(targetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.copyFile((File)this.copyTestSourceDir, (File)this.copyTestTargetDir);
        Assert.assertEquals((String)"The method copyFile(), if applied to directories, should overwrite existing directories!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryReplacementFileOverwrite() {
        File targetFile = new File(this.copyTestTargetFile.getParentFile(), this.copyTestSourceFile.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(targetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.replaceFile((File)targetFile.getParentFile(), (File)this.copyTestSourceFile.getParentFile());
        Assert.assertEquals((String)"The method replaceFile() should overwrite existing files in a targeted directory!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryReplacementSourceDeletion() {
        File targetFile = new File(this.copyTestTargetFile.getParentFile(), this.copyTestSourceFile.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(targetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.replaceFile((File)targetFile.getParentFile(), (File)this.copyTestSourceFile.getParentFile());
        Assert.assertFalse((String)"The method replaceFile(), when applied to a directory, should delete the source directory!", (boolean)this.copyTestSourceFile.getParentFile().exists());
    }

    @Test
    public void testDirectoryReplacementCleanUp() {
        File targetFile = new File(this.copyTestTargetFile.getParentFile(), this.copyTestSourceFile.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        diskIo.writeStringToFile(targetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        FileUtils.replaceFile((File)targetFile.getParentFile(), (File)this.copyTestSourceFile.getParentFile());
        Assert.assertFalse((String)"The method replaceFile() should clean up all backup files created in the process!", (boolean)new File(targetFile.getPath() + ".tmp").exists());
    }

    @Test
    public void testDirectoryReplacementWithoutTarget() {
        File targetFile = new File(this.copyTestTargetDir, this.copyTestSourceFile.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(this.copyTestSourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        FileUtils.replaceFile((File)this.copyTestTargetDir, (File)this.copyTestSourceDir);
        Assert.assertEquals((String)"The method replaceFile() should create a target directory if it is missing!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryReplacementWithoutSource() {
        FileUtils.replaceFile((File)this.copyTestTargetDir, (File)this.copyTestSourceDir);
        Assert.assertFalse((String)"The method replaceFile() should not create directories if the source directory is missing!", (boolean)this.copyTestTargetDir.exists());
    }

    @Test
    public void testReplacingDirectoryMergeWithTarget() {
        this.assertDirectoryIntegration(true);
    }

    @Test
    public void testNonReplacingDirectoryMergeWithTarget() {
        this.assertDirectoryIntegration(false);
    }

    @Test
    public void testDirectoryMergeWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : this.mergeTestSourceFiles) {
            diskIo.writeStringToFile(sourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        }
        FileUtils.integrateDirectory((File)this.mergeTestSourceDir, (File)this.mergeTestTargetDir, (boolean)false);
        for (File targetFile : this.mergeTestMergedSourceFiles) {
            Assert.assertEquals((String)"The method integrateDirectory() should create target directories if they are missing!", (Object)"Milch macht m\u00fcde M\u00e4nner munter.", (Object)diskIo.getString(targetFile));
        }
    }

    @Test
    public void testDirectoryMergeWithoutTargetRemovingOldDirectory() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : this.mergeTestSourceFiles) {
            diskIo.writeStringToFile(sourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        }
        FileUtils.integrateDirectory((File)this.mergeTestSourceDir, (File)this.mergeTestTargetDir, (boolean)false);
        for (File sourceFile : this.mergeTestSourceFiles) {
            Assert.assertFalse((String)"The method integrateDirectory() should remove all source files!", (boolean)sourceFile.exists());
        }
    }

    @Test
    public void testDirectoryMergeWithoutSource() {
        FileUtils.integrateDirectory((File)this.mergeTestSourceDir, (File)this.mergeTestTargetDir, (boolean)false);
        Assert.assertFalse((String)"The method integrateDirectory() should not create directories if the source does not exist!", (boolean)this.mergeTestTargetDir.exists());
    }

    @Test
    public void testDirectoryMergeCompletion() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : this.mergeTestSourceFiles) {
            diskIo.writeStringToFile(sourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        }
        for (File targetFile : this.mergeTestTargetFiles) {
            diskIo.writeStringToFile(targetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        }
        FileUtils.integrateDirectory((File)this.mergeTestSourceDir, (File)this.mergeTestTargetDir, (boolean)false);
        for (File targetFile : this.mergeTestExpectedTargetFiles) {
            Assert.assertTrue((String)"The method integrateDirectory() should merge all directories and files to a target directory!", (boolean)targetFile.exists());
        }
    }

    private void assertDirectoryIntegration(boolean replaceFiles) {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : this.mergeTestSourceFiles) {
            diskIo.writeStringToFile(sourceFile, "Milch macht m\u00fcde M\u00e4nner munter.");
        }
        for (File targetFile : this.mergeTestTargetFiles) {
            diskIo.writeStringToFile(targetFile, "Ohne Krimi geht die Mimi nie ins Bett.");
        }
        FileUtils.integrateDirectory((File)this.mergeTestSourceDir, (File)this.mergeTestTargetDir, (boolean)replaceFiles);
        File possiblyReplacedFile = this.mergeTestTargetFiles.get(0);
        String expectedFileContent = replaceFiles ? "Milch macht m\u00fcde M\u00e4nner munter." : "Ohne Krimi geht die Mimi nie ins Bett.";
        Assert.assertEquals((String)"The method integrateDirectory() should merge all files to the target directory!", (Object)expectedFileContent, (Object)diskIo.getString(possiblyReplacedFile));
    }
}

