/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler;

import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.scheduler.json.ChangeSchedulerRequest;
import de.gerdiproject.harvest.scheduler.json.SchedulerResponse;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class SchedulerTest
extends AbstractObjectUnitTest<Scheduler> {
    private static final String INVALID_CRON = "abc";
    private static final String RANDOM_CRON_TAB = "%d 0 1 1 *";
    private static final String SOME_CRON_TAB = "0 0 1 1 *";
    private static final String ASSERT_EXCEPTION_MESSAGE = "Expected an " + IllegalArgumentException.class.getSimpleName() + " to be thrown when the same task is added twice!";
    private final File scheduleFile = new File(this.getTemporaryTestDirectory(), "schedule.json");

    @Override
    protected Scheduler setUpTestObjects() {
        Scheduler scheduler = new Scheduler("", this.scheduleFile.toString());
        return scheduler;
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((String)"The method size() should return 0 after the constructor was called", (long)0L, (long)((Scheduler)this.testedObject).size());
    }

    @Test
    public void testSavingToDisk() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addTasks(1);
        Assert.assertNotEquals((String)"After adding a task, the cache file should not be empty!", (long)0L, (long)this.scheduleFile.length());
    }

    @Test
    public void testLoadingFromDisk() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addRandomNumberOfTasks();
        Scheduler anotherScheduler = new Scheduler("", this.scheduleFile.toString());
        anotherScheduler.addEventListeners();
        anotherScheduler.loadFromDisk();
        anotherScheduler.removeEventListeners();
        Assert.assertEquals((String)"The method size() of a Scheduler that is saved to disk should return the same value as a Scheduler that was loaded from the cache file!", (long)((Scheduler)this.testedObject).size(), (long)anotherScheduler.size());
    }

    @Test
    public void testLoadingFromDiskNoExists() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addRandomNumberOfTasks();
        int oldSize = ((Scheduler)this.testedObject).size();
        ((Scheduler)this.testedObject).loadFromDisk();
        Assert.assertEquals((String)"The scheduled tasks should not change if a non-existing cache file is attempted to be loaded!", (long)oldSize, (long)((Scheduler)this.testedObject).size());
    }

    @Test
    public void testAddingTask() {
        ((Scheduler)this.testedObject).addEventListeners();
        int numberOfTasks = this.random.nextInt(10);
        this.addTasks(numberOfTasks);
        Assert.assertEquals((String)"The method size() should return the same number of tasks that were added!", (long)numberOfTasks, (long)((Scheduler)this.testedObject).size());
    }

    @Test
    public void testAddingTaskTwice() {
        ((Scheduler)this.testedObject).addEventListeners();
        try {
            ((Scheduler)this.testedObject).addTask(new ChangeSchedulerRequest(SOME_CRON_TAB));
            ((Scheduler)this.testedObject).addTask(new ChangeSchedulerRequest(SOME_CRON_TAB));
            Assert.fail((String)"Adding the same cron tab twice should throw an exception!");
        }
        catch (Exception ex) {
            Assert.assertEquals((String)ASSERT_EXCEPTION_MESSAGE, IllegalArgumentException.class, ex.getClass());
        }
    }

    @Test
    public void testAddingTaskInvalidCronTab() {
        ((Scheduler)this.testedObject).addEventListeners();
        try {
            ((Scheduler)this.testedObject).addTask(new ChangeSchedulerRequest(INVALID_CRON));
            Assert.fail((String)"Adding a cron tab with invalid syntax should throw an exception!");
        }
        catch (Exception ex) {
            Assert.assertEquals((String)ASSERT_EXCEPTION_MESSAGE, IllegalArgumentException.class, ex.getClass());
        }
    }

    @Test
    public void testDeletingTask() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addTasks(10);
        int numberOfDeletions = 1 + this.random.nextInt(10);
        for (int i = 0; i < numberOfDeletions; ++i) {
            String randomCron = String.format(RANDOM_CRON_TAB, i);
            ((Scheduler)this.testedObject).deleteTask(new ChangeSchedulerRequest(randomCron));
        }
        Assert.assertEquals((String)"The method size() should return a lower number after deleting tasks!", (long)(10 - numberOfDeletions), (long)((Scheduler)this.testedObject).size());
    }

    @Test
    public void testDeletingTaskNonExisting() {
        ((Scheduler)this.testedObject).addEventListeners();
        try {
            ((Scheduler)this.testedObject).deleteTask(new ChangeSchedulerRequest(SOME_CRON_TAB));
            Assert.fail((String)"Deleting a non-existing cron tab should throw an exception!");
        }
        catch (Exception ex) {
            Assert.assertEquals((String)ASSERT_EXCEPTION_MESSAGE, IllegalArgumentException.class, ex.getClass());
        }
    }

    @Test
    public void testDeletingAllTasks() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addTasks(10);
        ((Scheduler)this.testedObject).deleteAllTasks();
        Assert.assertEquals((String)"The method deleteAllTasks() should remove all tasks!", (long)0L, (long)((Scheduler)this.testedObject).size());
    }

    @Test
    public void testDeletingAllTasksNonExisting() {
        ((Scheduler)this.testedObject).addEventListeners();
        try {
            ((Scheduler)this.testedObject).deleteAllTasks();
        }
        catch (Exception ex) {
            Assert.fail((String)"Deleting all cron tabs should not throw an exception!");
        }
    }

    @Test
    public void testScheduleGetter() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addRandomNumberOfTasks();
        String scheduleText = ((Scheduler)this.testedObject).getAsPlainText();
        for (int i = 0; i < ((Scheduler)this.testedObject).size(); ++i) {
            Assert.assertTrue((String)"The method getRestText() should return all tasks!", (boolean)scheduleText.contains(String.format(RANDOM_CRON_TAB, i)));
        }
    }

    @Test
    public void testScheduleGetterEmpty() {
        ((Scheduler)this.testedObject).addEventListeners();
        SchedulerResponse scheduleJson = ((Scheduler)this.testedObject).getAsJson(null);
        Assert.assertTrue((String)"The method getRestText() should return no tasks, if none were added!", (boolean)scheduleJson.getScheduledHarvests().isEmpty());
    }

    @Test
    public void testTaskRemovalOnContextDestruction() {
        ((Scheduler)this.testedObject).addEventListeners();
        this.addRandomNumberOfTasks();
        EventSystem.sendEvent((IEvent)new ContextDestroyedEvent());
        Assert.assertEquals((String)("The " + ContextDestroyedEvent.class.getSimpleName() + " should cause all tasks to be deleted!"), (long)0L, (long)((Scheduler)this.testedObject).size());
    }

    @Test
    public void testForNoEventsOnContextDestruction() {
        ((Scheduler)this.testedObject).addEventListeners();
        EventSystem.sendEvent((IEvent)new ContextDestroyedEvent());
        try {
            this.addTasks(1);
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)("Tasks must not be added after the " + ContextDestroyedEvent.class.getSimpleName() + " was sent!"));
    }

    private void addTasks(int count) {
        for (int i = 0; i < count; ++i) {
            String randomCron = String.format(RANDOM_CRON_TAB, i);
            ((Scheduler)this.testedObject).addTask(new ChangeSchedulerRequest(randomCron));
        }
    }

    private void addRandomNumberOfTasks() {
        this.addTasks(1 + this.random.nextInt(10));
    }
}

