/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.transformers;

import de.gerdiproject.harvest.AbstractETLUnitTest;
import de.gerdiproject.harvest.application.ContextListenerTestWrapper;
import de.gerdiproject.harvest.etls.AbstractIteratorETL;
import de.gerdiproject.harvest.etls.EtlUnitTestUtils;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.transformers.AbstractIteratorTransformer;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.json.GsonUtils;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractIteratorTransformerTest<T, S>
extends AbstractETLUnitTest<AbstractIteratorTransformer<T, S>, T> {
    private static final String WRONG_OBJECT_ERROR = "The transformed object from %s is not as expected!";
    private static final String NON_NULL_OBJECT_ERROR = "Expected the %s to return an empty iterator when transforming an empty iterator!";
    private static final String NULL_INPUT_ERROR = "Expected the mocked input value to not be null!";
    protected final DiskIO diskIo = new DiskIO(GsonUtils.createGerdiDocumentGsonBuilder().create(), StandardCharsets.UTF_8);

    protected Class<T> getExtractedClass() {
        Class<?> thisClass = this.getClass();
        while (!thisClass.getSuperclass().equals(AbstractIteratorTransformerTest.class)) {
            thisClass = thisClass.getSuperclass();
        }
        return (Class)((ParameterizedType)thisClass.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected Class<S> getTransformedClass() {
        Class<?> thisClass = this.getClass();
        while (!thisClass.getSuperclass().equals(AbstractIteratorTransformerTest.class)) {
            thisClass = thisClass.getSuperclass();
        }
        return (Class)((ParameterizedType)thisClass.getGenericSuperclass()).getActualTypeArguments()[1];
    }

    protected T getMockedInput() {
        Class<T> extractedClass = this.getExtractedClass();
        if (Element.class.isAssignableFrom(extractedClass)) {
            File resource = this.getResource("input.html");
            return (T)this.diskIo.getHtml(resource.toString());
        }
        File resource = this.getResource("input.json");
        return (T)this.diskIo.getObject(resource, extractedClass);
    }

    protected S getExpectedOutput() {
        Class<S> transformedClass = this.getTransformedClass();
        if (Element.class.isAssignableFrom(transformedClass)) {
            File resource = this.getResource("output.html");
            return (S)this.diskIo.getHtml(resource.toString());
        }
        File resource = this.getResource("output.json");
        return (S)this.diskIo.getObject(resource, transformedClass);
    }

    @Override
    protected AbstractIteratorTransformer<T, S> setUpTestedObjectFromContextInitializer(ContextListenerTestWrapper<? extends AbstractIteratorETL<T, ?>> contextInitializer) {
        AbstractIteratorTransformer transformer = (AbstractIteratorTransformer)EtlUnitTestUtils.getTransformer(contextInitializer.getEtl());
        transformer.init(contextInitializer.getEtl());
        return transformer;
    }

    @Test
    public void testMockedInputNonNull() {
        Assert.assertNotNull((String)NULL_INPUT_ERROR, this.getMockedInput());
    }

    @Test
    public void testTransformElement() {
        T mockedInput = this.getMockedInput();
        Object actualOutput = ((AbstractIteratorTransformer)this.testedObject).transformElement(mockedInput);
        S expectedOutput = this.getExpectedOutput();
        Assert.assertEquals((String)String.format(WRONG_OBJECT_ERROR, ((AbstractIteratorTransformer)this.testedObject).getClass().getSimpleName()), expectedOutput, (Object)actualOutput);
    }

    @Test
    public void testTransformEmptyIterator() {
        List<Object> emptyInput = Arrays.asList(new Object[0]);
        Iterator emptyOutput = ((AbstractIteratorTransformer)this.testedObject).transform(emptyInput.iterator());
        Assert.assertFalse((String)String.format(NON_NULL_OBJECT_ERROR, ((AbstractIteratorTransformer)this.testedObject).getClass().getSimpleName()), (boolean)emptyOutput.hasNext());
    }

    @Test(expected=ExtractorException.class)
    public void testTransformNull() {
        Iterator nullOutput = ((AbstractIteratorTransformer)this.testedObject).transform(null);
        nullOutput.next();
    }
}

