/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.loaders.DiskLoader;
import de.gerdiproject.harvest.etls.loaders.constants.DiskLoaderConstants;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.examples.MockedETL;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class DiskLoaderTest
extends AbstractObjectUnitTest<DiskLoader> {
    private static final String SOURCE_ID = "source";
    private static final String HARVESTER_HASH = "ABC";
    private static final String JSON_PUBLICATION_YEAR = "publicationYear";
    private static final String ASSERT_JSON_MESSAGE = "The JSON field '%s' was not properly saved or loaded!";
    private MockedETL etl;

    @Override
    protected DiskLoader setUpTestObjects() {
        StringParameter filePathParam = DiskLoaderConstants.FILE_PATH_PARAM.copy();
        filePathParam.setValue(this.getTemporaryTestDirectory().toString());
        this.config = new Configuration("UnitTestModule", new AbstractParameter[]{filePathParam});
        this.config.addEventListeners();
        this.etl = new MockedETL();
        return new DiskLoader();
    }

    @Test
    public void testFileContentDocuments() {
        ((DiskLoader)this.testedObject).init((AbstractETL)this.etl);
        Iterator<DataCiteJson> docIter = this.createRandomNumberOfSaveableDocuments();
        this.etl.setStatus(ETLState.HARVESTING);
        ((DiskLoader)this.testedObject).load(docIter);
        ((DiskLoader)this.testedObject).clear();
        DiskIO diskReader = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        JsonObject fileContent = (JsonObject)diskReader.getObject(((DiskLoader)this.testedObject).createTargetFile(this.etl.getName()), JsonObject.class);
        JsonArray loadedDocuments = fileContent.get("documents").getAsJsonArray();
        for (int i = 0; i < loadedDocuments.size(); ++i) {
            Assert.assertTrue((String)("The publication year of every saved object must be lower than " + loadedDocuments.size() + ", because it equals the index of the document!"), (loadedDocuments.get(i).getAsJsonObject().get(JSON_PUBLICATION_YEAR).getAsInt() < loadedDocuments.size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileContentHarvesterHash() {
        String sourceHash = HARVESTER_HASH + this.random.nextInt(1000);
        this.etl.setHash(sourceHash);
        ((DiskLoader)this.testedObject).init((AbstractETL)this.etl);
        Iterator<DataCiteJson> docIter = this.createRandomNumberOfSaveableDocuments();
        this.etl.setStatus(ETLState.HARVESTING);
        ((DiskLoader)this.testedObject).load(docIter);
        ((DiskLoader)this.testedObject).clear();
        DiskIO diskReader = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        JsonObject fileContent = (JsonObject)diskReader.getObject(((DiskLoader)this.testedObject).createTargetFile(this.etl.getName()), JsonObject.class);
        Assert.assertEquals((String)String.format(ASSERT_JSON_MESSAGE, "sourceHash"), (Object)sourceHash, (Object)fileContent.get("sourceHash").getAsString());
    }

    @Test
    public void testSaveFailedNoDocuments() {
        ((DiskLoader)this.testedObject).init((AbstractETL)this.etl);
        LinkedList emptyList = new LinkedList();
        Iterator docIter = emptyList.iterator();
        ((DiskLoader)this.testedObject).load(docIter);
        ((DiskLoader)this.testedObject).clear();
        Assert.assertFalse((String)"Expected that no file was to be created when no documents were harvested!", (boolean)((DiskLoader)this.testedObject).createTargetFile(this.etl.getName()).exists());
    }

    private Iterator<DataCiteJson> createRandomNumberOfSaveableDocuments() {
        LinkedList<DataCiteJson> list = new LinkedList<DataCiteJson>();
        int numberOfHarvestedDocuments = 1 + this.random.nextInt(10);
        for (int i = 0; i < numberOfHarvestedDocuments; ++i) {
            DataCiteJson doc = new DataCiteJson(SOURCE_ID + i);
            doc.setPublicationYear(Integer.valueOf(i));
            list.add(doc);
        }
        return list.iterator();
    }
}

