/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.extractors;

import de.gerdiproject.harvest.AbstractETLUnitTest;
import de.gerdiproject.harvest.application.ContextListenerTestWrapper;
import de.gerdiproject.harvest.etls.AbstractIteratorETL;
import de.gerdiproject.harvest.etls.EtlUnitTestUtils;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.json.GsonUtils;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractIteratorExtractorTest<T>
extends AbstractETLUnitTest<AbstractIteratorExtractor<T>, T> {
    protected static final String WRONG_OBJECT_ERROR = "The extracted object from %s is not as expected!";
    protected final DiskIO diskIo = new DiskIO(GsonUtils.createGerdiDocumentGsonBuilder().create(), StandardCharsets.UTF_8);

    protected Class<T> getExtractedClass() {
        Class<?> thisClass = this.getClass();
        while (!thisClass.getSuperclass().equals(AbstractIteratorExtractorTest.class)) {
            thisClass = thisClass.getSuperclass();
        }
        return (Class)((ParameterizedType)thisClass.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected T getExpectedOutput() {
        Class<T> extractedClass = this.getExtractedClass();
        if (Element.class.isAssignableFrom(extractedClass)) {
            File resource = this.getResource("output.html");
            return (T)this.diskIo.getHtml(resource.toString());
        }
        File resource = this.getResource("output.json");
        return (T)this.diskIo.getObject(resource, extractedClass);
    }

    @Test
    public void testExtractElementNonNull() {
        Object actualOutput = ((AbstractIteratorExtractor)this.testedObject).extract().next();
        Assert.assertNotNull(actualOutput);
    }

    @Test
    public void testExtractElement() {
        Object actualOutput = ((AbstractIteratorExtractor)this.testedObject).extract().next();
        T expectedOutput = this.getExpectedOutput();
        this.assertExpectedOutput(expectedOutput, actualOutput);
    }

    @Override
    protected AbstractIteratorExtractor<T> setUpTestedObjectFromContextInitializer(ContextListenerTestWrapper<? extends AbstractIteratorETL<T, ?>> contextInitializer) {
        AbstractIteratorExtractor extractor = (AbstractIteratorExtractor)EtlUnitTestUtils.getExtractor(contextInitializer.getEtl());
        extractor.init(contextInitializer.getEtl());
        return extractor;
    }

    protected void assertExpectedOutput(T expectedOutput, T actualOutput) {
        if (Element.class.isAssignableFrom(this.getExtractedClass())) {
            Assert.assertTrue((String)String.format(WRONG_OBJECT_ERROR, ((AbstractIteratorExtractor)this.testedObject).getClass().getSimpleName()), (boolean)((Element)expectedOutput).hasSameValue(actualOutput));
        } else {
            Assert.assertEquals((String)String.format(WRONG_OBJECT_ERROR, ((AbstractIteratorExtractor)this.testedObject).getClass().getSimpleName()), expectedOutput, actualOutput);
        }
    }
}

