/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.json.adapters.ConfigurationAdapter;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.PasswordParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.utils.data.DiskIO;
import java.io.File;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest
extends AbstractObjectUnitTest<Configuration> {
    private static final String MODULE_NAME = "mocked";
    private static final String PARAM_KEY = "customParam";
    private static final String STRING_VALUE = "customValue";
    private static final String PASSWORD_VALUE_1 = "top secret";
    private static final String PASSWORD_VALUE_2 = "no one must know";
    private static final int INT_VALUE_1 = 42;
    private static final int INT_VALUE_2 = 1337;
    private static final boolean BOOL_VALUE_1 = false;
    private static final boolean BOOL_VALUE_2 = true;
    private static final String TEST_CATEGORY = "TestCategory";
    private static final String ERROR_ARGUMENTS_MUST_DIFFER = "The old and new value of parameter change tests must differ!";
    private static final String ERROR_MISSING_LOADED_PARAM = "Expected parameter '%s' to be loaded after being saved!";
    private final File configFile = new File(this.getTemporaryTestDirectory(), "config.json");
    private StringParameter testedParam;

    @Override
    protected Configuration setUpTestObjects() {
        this.testedParam = new StringParameter(PARAM_KEY, TEST_CATEGORY, STRING_VALUE);
        return this.createConfigWithCustomParameters(new AbstractParameter[]{this.testedParam});
    }

    @Test
    public void testNullConstructor() {
        this.testedObject = new Configuration(MODULE_NAME, new AbstractParameter[0]);
        Assert.assertEquals((String)"The method getParameters() should return an empty list after the constructor without arguments is called!", (long)0L, (long)((Configuration)this.testedObject).getParameters().size());
    }

    @Test
    public void testCustomHarvesterParamsConstructor() {
        AbstractParameter[] customHarvesterParams = new AbstractParameter[]{new StringParameter("customParam1", TEST_CATEGORY, "customValue1"), new StringParameter("customParam2", TEST_CATEGORY, "customValue2"), new StringParameter("customParam3", TEST_CATEGORY, "customValue3")};
        this.testedObject = new Configuration(MODULE_NAME, customHarvesterParams);
        for (AbstractParameter param : customHarvesterParams) {
            Assert.assertEquals((String)"The method getParameterValue() should return a list of all parameters that were passed to the constructor", (Object)param.getValue(), (Object)((Configuration)this.testedObject).getParameterValue(param.getCompositeKey()));
        }
    }

    @Test
    public void testGettingParameterIgnoreCase() {
        String randomValue = STRING_VALUE + this.random.nextInt(10000);
        StringParameter paramWithCase = new StringParameter(PARAM_KEY, TEST_CATEGORY, randomValue);
        this.testedObject = new Configuration(MODULE_NAME, new AbstractParameter[]{paramWithCase});
        String upperCaseKey = paramWithCase.getCompositeKey().toUpperCase();
        Assert.assertEquals((String)"The method getParameterValue() should be case insensitive!", (Object)randomValue, (Object)((Configuration)this.testedObject).getParameterValue(upperCaseKey));
    }

    @Test
    public void testRegisteringKnownParam() {
        ((Configuration)this.testedObject).addEventListeners();
        AbstractParameter registeredParam = Configuration.registerParameter((AbstractParameter)this.testedParam);
        Assert.assertEquals((String)"The static method registerParameter() should return the same instance of a parameter if it was already added to the Configuration!", (Object)registeredParam, (Object)this.testedParam);
    }

    @Test
    public void testRegisteringParamWithTheSameCompositeKey() {
        ((Configuration)this.testedObject).addEventListeners();
        AbstractParameter registeredParam1 = Configuration.registerParameter((AbstractParameter)this.testedParam.copy());
        AbstractParameter registeredParam2 = Configuration.registerParameter((AbstractParameter)this.testedParam.copy());
        Assert.assertEquals((String)"Registering the same parmeter multiple times should return a reference to the same object!", (Object)registeredParam1, (Object)registeredParam2);
    }

    @Test
    public void testRegisteringCopyParameter() {
        ((Configuration)this.testedObject).addEventListeners();
        IntegerParameter unknownParam = new IntegerParameter("customParam2", TEST_CATEGORY, 0);
        AbstractParameter registeredParam = Configuration.registerParameter((AbstractParameter)unknownParam);
        Assert.assertNotEquals((String)"Registering a parameter object for the first time should register a copy instead of the original reference!", (Object)registeredParam, (Object)unknownParam);
    }

    @Test
    public void testRegisteringTwiceDoNotOverride() {
        ((Configuration)this.testedObject).addEventListeners();
        int oldValue = this.random.nextInt(1000);
        int newValueValue = oldValue + 1;
        IntegerParameter param1 = new IntegerParameter("customParam1", TEST_CATEGORY, oldValue);
        IntegerParameter param2 = new IntegerParameter("customParam1", TEST_CATEGORY, newValueValue);
        Configuration.registerParameter((AbstractParameter)param1);
        Assert.assertEquals((String)"Registering a parameter should not override the value if the parameter is known by the Configuration!", (Object)oldValue, (Object)Configuration.registerParameter((AbstractParameter)param2).getValue());
    }

    @Test(expected=IllegalStateException.class)
    public void testRegisteringWithoutConfig() {
        Configuration.registerParameter((AbstractParameter)this.testedParam);
        Assert.fail((String)"Registering a parameter while the Configuration has no listeners should throw an IllegalStateException!");
    }

    @Test
    public void testStringParameterChange() {
        StringParameter param = new StringParameter(PARAM_KEY, TEST_CATEGORY, "customValue1");
        this.assertThatParmeterValueCanChange((AbstractParameter)param, (Object)"customValue2");
    }

    @Test
    public void testIntegerParameterChange() {
        IntegerParameter param = new IntegerParameter(PARAM_KEY, TEST_CATEGORY, 42);
        this.assertThatParmeterValueCanChange((AbstractParameter)param, 1337);
    }

    @Test
    public void testBooleanParameterChange() {
        BooleanParameter param = new BooleanParameter(PARAM_KEY, TEST_CATEGORY, false);
        this.assertThatParmeterValueCanChange((AbstractParameter)param, true);
    }

    @Test
    public void testPasswordParameterChange() {
        PasswordParameter param = new PasswordParameter(PARAM_KEY, TEST_CATEGORY, PASSWORD_VALUE_1);
        this.assertThatParmeterValueCanChange((AbstractParameter)param, (Object)PASSWORD_VALUE_2);
    }

    @Test
    public void testPasswordParameterMasking() {
        PasswordParameter param = new PasswordParameter(PARAM_KEY, TEST_CATEGORY, PASSWORD_VALUE_1);
        Assert.assertFalse((String)"The value of a PasswordParameter must not be readable via getStringValue()!", (boolean)param.getStringValue().contains(((String)param.getValue()).toString()));
    }

    @Test
    public void testSaveWithPath() {
        ((Configuration)this.testedObject).setCacheFilePath(this.configFile.getAbsolutePath());
        ((Configuration)this.testedObject).saveToDisk();
        Assert.assertTrue((String)"The method saveToDisk() should create a file on disk!", (this.configFile.exists() && this.configFile.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testSaveWithoutPath() {
        this.setLoggerEnabled(false);
        ((Configuration)this.testedObject).saveToDisk();
        this.setLoggerEnabled(true);
        Assert.assertFalse((String)"If  the method setCacheFilePath() is not called prior to calling saveToDisk(), a file should not be created!", (boolean)this.configFile.exists());
    }

    @Test
    public void testLoadingPresentValues() {
        Object savedParamValue = this.testedParam.getValue();
        this.testedParam.setRegistered(true);
        Configuration savedConfig = this.createConfigWithCustomParameters(new AbstractParameter[]{this.testedParam});
        savedConfig.setCacheFilePath(this.configFile.getAbsolutePath());
        savedConfig.saveToDisk();
        ((Configuration)this.testedObject).setCacheFilePath(this.configFile.getAbsolutePath());
        String valueToBeRestored = "override me";
        ((Configuration)this.testedObject).setParameter(this.testedParam.getCompositeKey(), "override me");
        this.setLoggerEnabled(false);
        ((Configuration)this.testedObject).loadFromDisk();
        this.setLoggerEnabled(true);
        Assert.assertEquals((String)"The method loadFromDisk() should overwrite existing Parmeter values!", (Object)savedParamValue, (Object)((Configuration)this.testedObject).getParameterValue(this.testedParam.getCompositeKey()));
    }

    @Test
    public void testLoadingNonPresentValues() {
        Object savedParamValue = this.testedParam.getValue();
        this.testedParam.setRegistered(true);
        Configuration savedConfig = this.createConfigWithCustomParameters(new AbstractParameter[]{this.testedParam});
        savedConfig.setCacheFilePath(this.configFile.getAbsolutePath());
        savedConfig.saveToDisk();
        this.testedObject = new Configuration(MODULE_NAME, new AbstractParameter[0]);
        ((Configuration)this.testedObject).setCacheFilePath(this.configFile.getAbsolutePath());
        this.setLoggerEnabled(false);
        ((Configuration)this.testedObject).loadFromDisk();
        this.setLoggerEnabled(true);
        Assert.assertEquals((String)"The method loadFromDisk() should create parameters that did not exist!", (Object)savedParamValue, (Object)((Configuration)this.testedObject).getParameterValue(this.testedParam.getCompositeKey()));
    }

    @Test
    public void testLoadWithNonExistingPath() {
        this.testedObject = new Configuration(MODULE_NAME, new AbstractParameter[0]);
        ((Configuration)this.testedObject).setCacheFilePath(this.configFile.getAbsolutePath());
        this.setLoggerEnabled(false);
        ((Configuration)this.testedObject).loadFromDisk();
        this.setLoggerEnabled(true);
        Assert.assertTrue((String)"Loading a non-existing Configuration should not cause any changes!", (boolean)((Configuration)this.testedObject).getParameters().isEmpty());
    }

    @Test
    public void testLoadWithoutSetPath() {
        this.testedParam.setRegistered(true);
        Configuration savedConfig = this.createConfigWithCustomParameters(new AbstractParameter[]{this.testedParam});
        savedConfig.setCacheFilePath(this.configFile.getAbsolutePath());
        savedConfig.saveToDisk();
        String valueToBeOverridden = "override me";
        this.testedParam.setValue("override me");
        this.setLoggerEnabled(false);
        ((Configuration)this.testedObject).loadFromDisk();
        this.setLoggerEnabled(true);
        Assert.assertEquals((String)"The method loadFromDisk() should not cause changes if setCacheFilePath() was not called in advance!", (Object)"override me", (Object)((Configuration)this.testedObject).getParameterStringValue(this.testedParam.getCompositeKey()));
    }

    @Test
    public void testJsonSerializationParameterTypes() throws MalformedURLException {
        Configuration savedConfig = this.createConfigWithAllParameterTypes();
        savedConfig.getParameters().forEach(param -> param.setRegistered(true));
        this.testedObject = this.saveAndLoadConfig(savedConfig);
        Collection loadedParams = ((Configuration)this.testedObject).getParameters();
        for (AbstractParameter param2 : savedConfig.getParameters()) {
            boolean hasLoadedParameter = false;
            for (AbstractParameter loadedParam : loadedParams) {
                if (!loadedParam.getCompositeKey().equals(param2.getCompositeKey())) continue;
                Assert.assertEquals((String)"The class of a saved parmeter must not change when the parmeter is loaded!", param2.getClass(), loadedParam.getClass());
                hasLoadedParameter = true;
                break;
            }
            if (hasLoadedParameter) continue;
            Assert.fail((String)String.format(ERROR_MISSING_LOADED_PARAM, param2));
        }
    }

    @Test
    public void testJsonSerializationOfNullValues() throws MalformedURLException {
        Configuration savedConfig = this.createConfigWithCustomParameters(new AbstractParameter[]{new StringParameter("customParam1", TEST_CATEGORY, null), new PasswordParameter("customParam5", TEST_CATEGORY, null)});
        savedConfig.getParameters().forEach(param -> param.setRegistered(true));
        this.testedObject = this.saveAndLoadConfig(savedConfig);
        for (AbstractParameter param2 : savedConfig.getParameters()) {
            Assert.assertEquals((String)"Saved parameters with null values must not change when loaded!", (Object)param2.getValue(), (Object)((Configuration)this.testedObject).getParameterValue(param2.getCompositeKey()));
        }
    }

    @Test
    public void testJsonSerializationParameterValues() throws MalformedURLException {
        Configuration savedConfig = this.createConfigWithAllParameterTypes();
        this.testedObject = this.saveAndLoadConfig(savedConfig);
        for (AbstractParameter param : savedConfig.getParameters()) {
            Assert.assertEquals((String)"The original values of saved Parmeters must match the values of the loaded Parameters!", (Object)param.getValue(), (Object)((Configuration)this.testedObject).getParameterValue(param.getCompositeKey()));
        }
    }

    @Test
    public void testParameterCopyClass() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        for (AbstractParameter param : ((Configuration)this.testedObject).getParameters()) {
            Assert.assertEquals((String)"The method copy() must preserve the class of the source object!", param.getClass(), param.copy().getClass());
        }
    }

    @Test
    public void testParameterCopyCategory() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        for (AbstractParameter param : ((Configuration)this.testedObject).getParameters()) {
            AbstractParameter clonedParam = param.copy();
            Assert.assertEquals((String)"The method copy() must preserve the 'category' field of the source object!", (Object)param.getCategory(), (Object)clonedParam.getCategory());
        }
    }

    @Test
    public void testParameterCopyValues() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        for (AbstractParameter param : ((Configuration)this.testedObject).getParameters()) {
            AbstractParameter clonedParam = param.copy();
            Assert.assertEquals((String)"The method copy() must preserve the 'value' field of the source object!", (Object)param.getValue(), (Object)clonedParam.getValue());
        }
    }

    @Test
    public void testParameterCopyKey() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        for (AbstractParameter param : ((Configuration)this.testedObject).getParameters()) {
            AbstractParameter clonedParam = param.copy();
            Assert.assertEquals((String)"The method copy() must preserve the 'key' field of the source object!", (Object)param.getKey(), (Object)clonedParam.getKey());
        }
    }

    @Test
    public void testParameterCopyNotTheSame() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        for (AbstractParameter param : ((Configuration)this.testedObject).getParameters()) {
            Assert.assertNotEquals((String)"The method copy() must not return a reference to the source object!", (Object)param, (Object)param.copy());
        }
    }

    @Test
    public void testPlainTextKeys() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        ((Configuration)this.testedObject).getParameters().forEach(param -> param.setRegistered(true));
        String configString = ((Configuration)this.testedObject).getAsPlainText();
        for (AbstractParameter param2 : ((Configuration)this.testedObject).getParameters()) {
            Assert.assertTrue((String)"The method toString() must return a string containing all registered parameter keys!", (boolean)configString.contains(param2.getKey()));
        }
    }

    @Test
    public void testToStringValues() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        ((Configuration)this.testedObject).getParameters().forEach(param -> param.setRegistered(true));
        String configString = ((Configuration)this.testedObject).getAsPlainText();
        for (AbstractParameter param2 : ((Configuration)this.testedObject).getParameters()) {
            Assert.assertTrue((String)"The method toString() must return a string containing all parameter value string representations!", (boolean)configString.contains(param2.getStringValue()));
        }
    }

    @Test
    public void testToStringUnregisteredParameters() throws MalformedURLException {
        this.testedObject = this.createConfigWithAllParameterTypes();
        String configString = ((Configuration)this.testedObject).toString();
        for (AbstractParameter param : ((Configuration)this.testedObject).getParameters()) {
            Assert.assertFalse((String)"The method toString() must not display unregistered parmeters!", (boolean)configString.contains(param.getKey()));
        }
    }

    private <T> void assertThatParmeterValueCanChange(AbstractParameter<T> param, T newValue) {
        param.setRegistered(true);
        String compositeKey = param.getCompositeKey();
        Object oldValue = param.getValue();
        if (oldValue.equals(newValue)) {
            throw new IllegalArgumentException(ERROR_ARGUMENTS_MUST_DIFFER);
        }
        this.testedObject = this.createConfigWithCustomParameters(param);
        ((Configuration)this.testedObject).setParameter(compositeKey, newValue.toString());
        Assert.assertNotEquals((String)"The parameter value is supposed to change!", (Object)oldValue, (Object)((Configuration)this.testedObject).getParameterValue(compositeKey));
    }

    private Configuration createConfigWithCustomParameters(AbstractParameter<?> ... params) {
        return new Configuration(MODULE_NAME, params);
    }

    private Configuration createConfigWithAllParameterTypes() throws MalformedURLException {
        return this.createConfigWithCustomParameters(new AbstractParameter[]{new StringParameter("customParam1", TEST_CATEGORY, ""), new StringParameter("customParam2", TEST_CATEGORY, "customValue1"), new IntegerParameter("customParam3", TEST_CATEGORY, 0), new IntegerParameter("customParam4", TEST_CATEGORY, 42), new BooleanParameter("customParam5", TEST_CATEGORY, false), new BooleanParameter("customParam6", TEST_CATEGORY, true), new PasswordParameter("customParam8", TEST_CATEGORY, PASSWORD_VALUE_1)});
    }

    private Configuration saveAndLoadConfig(Configuration configToSave) {
        configToSave.setCacheFilePath(this.configFile.getAbsolutePath());
        configToSave.saveToDisk();
        Gson gson = new GsonBuilder().registerTypeAdapter(Configuration.class, (Object)new ConfigurationAdapter()).create();
        DiskIO diskIo = new DiskIO(gson, StandardCharsets.UTF_8);
        return (Configuration)diskIo.getObject(this.configFile, Configuration.class);
    }
}

