/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.AbstractUnitTest;
import de.gerdiproject.harvest.application.MainContext;
import de.gerdiproject.harvest.application.MainContextUtils;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.application.examples.MockedContextListener;
import de.gerdiproject.harvest.utils.Procedure;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MainContextTest
extends AbstractUnitTest {
    private static final int INIT_TIMEOUT = 5000;
    private static final String CLEANUP_CONFIG_ERROR = "Could not delete temporary config file for MainContext tests: ";
    private final MockedContextListener mockedContextListener;
    private final boolean shouldInitBeSuccessful;
    private final Procedure initFunction;
    private final File configFile;

    @Parameterized.Parameters(name="successful init: {0}")
    public static Object[] getParameters() {
        return new Object[]{Boolean.FALSE, Boolean.TRUE};
    }

    public MainContextTest(boolean shouldInitBeSuccessful) {
        this.shouldInitBeSuccessful = shouldInitBeSuccessful;
        this.mockedContextListener = new MockedContextListener();
        this.configFile = MainContextUtils.getConfigurationFile((String)this.mockedContextListener.getServiceName(), MainContextTest.class);
        this.initFunction = shouldInitBeSuccessful ? this.mockedContextListener::initializeMainContext : this.mockedContextListener::failMainContextInitialization;
    }

    @Override
    public void before() throws InstantiationException {
        super.before();
        FileUtils.deleteFile((File)this.configFile);
        if (this.configFile.exists()) {
            throw new InstantiationException(CLEANUP_CONFIG_ERROR + this.configFile.toString());
        }
    }

    @Override
    public void after() {
        super.after();
        FileUtils.deleteFile((File)this.configFile);
    }

    @Test
    public void testInitializationEvent() {
        ServiceInitializedEvent initDoneEvent = this.waitForEvent(ServiceInitializedEvent.class, 5000, this.initFunction);
        Assert.assertEquals((String)"Expected the method init() to send an event carrying the initialization success as payload!", (Object)this.shouldInitBeSuccessful, (Object)initDoneEvent.isSuccessful());
    }

    @Test
    public void testInitializationStateBefore() {
        Assert.assertFalse((String)"Expected the method isInitialized() to return false before initialization!", (boolean)MainContext.isInitialized());
    }

    @Test
    public void testInitializationStateAfterDestroy() {
        this.waitForEvent(ServiceInitializedEvent.class, 5000, this.initFunction);
        MainContext.destroy();
        Assert.assertFalse((String)"Expected the method isInitialized() to return false after calling destroy()!", (boolean)MainContext.isInitialized());
    }

    @Test
    public void testInitializationState() {
        this.waitForEvent(ServiceInitializedEvent.class, 5000, this.initFunction);
        Assert.assertTrue((String)"Expected the method isInitialized() to return true after initialization!", (boolean)MainContext.isInitialized());
    }

    @Test
    public void testFailedStateBefore() {
        Assert.assertFalse((String)"Expected the method hasFailed() to return false before the initialization!", (boolean)MainContext.hasFailed());
    }

    @Test
    public void testFailedStateAfterDestroy() {
        this.waitForEvent(ServiceInitializedEvent.class, 5000, this.initFunction);
        MainContext.destroy();
        Assert.assertFalse((String)"Expected the method hasFailed() to return false after calling destroy()!", (boolean)MainContext.hasFailed());
    }

    @Test
    public void testFailedState() {
        this.waitForEvent(ServiceInitializedEvent.class, 5000, this.initFunction);
        Assert.assertNotEquals((String)("Expected the method hasFailed() to return " + this.shouldInitBeSuccessful + " after initialization!"), (Object)this.shouldInitBeSuccessful, (Object)MainContext.hasFailed());
    }
}

