/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.MainContext;
import de.gerdiproject.harvest.application.MainContextUtils;
import de.gerdiproject.harvest.application.events.ContextInitializedEvent;
import de.gerdiproject.harvest.application.events.ResetContextEvent;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class ContextListenerTestWrapper<T extends AbstractETL<?, ?>> {
    private final ContextListener wrappedContextListener;
    private final Supplier<T> etlSupplier;
    private T etl;

    public T getEtl() {
        if (this.etl == null) {
            this.etl = (AbstractETL)this.etlSupplier.get();
        }
        return this.etl;
    }

    public void initializeContext() {
        EventSystem.addListener(ResetContextEvent.class, arg_0 -> ((ContextListener)this.wrappedContextListener).onResetContext(arg_0));
        MainContext.init(this.wrappedContextListener.getClass(), () -> ((ContextListener)this.wrappedContextListener).getRepositoryName(), () -> Arrays.asList(this.getEtl()), (List)this.wrappedContextListener.getLoaderClasses());
        EventSystem.sendEvent((IEvent)new ContextInitializedEvent());
    }

    public File getConfigFile() {
        return MainContextUtils.getConfigurationFile((String)this.wrappedContextListener.getServiceName(), this.wrappedContextListener.getClass());
    }

    public ContextListenerTestWrapper(ContextListener wrappedContextListener, Supplier<T> etlSupplier) {
        this.wrappedContextListener = wrappedContextListener;
        this.etlSupplier = etlSupplier;
    }
}

