/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.application.examples.MockedContextListener;
import org.junit.Assert;
import org.junit.Test;

public final class ContextListenerTest
extends AbstractObjectUnitTest<ContextListener> {
    private static final int INIT_TIMEOUT = 5000;

    @Override
    protected MockedContextListener setUpTestObjects() {
        return new MockedContextListener();
    }

    @Test
    public void testServiceDeployment() {
        ServiceInitializedEvent initializationDoneEvent = this.waitForEvent(ServiceInitializedEvent.class, 5000, () -> ((ContextListener)this.testedObject).contextInitialized(null));
        Assert.assertTrue((String)"The contextInitialized() callback method should trigger a successful MainContext initialization!", (boolean)initializationDoneEvent.isSuccessful());
    }

    @Test
    public void testServiceUndeployment() {
        this.waitForEvent(ServiceInitializedEvent.class, 5000, () -> ((ContextListener)this.testedObject).contextInitialized(null));
        System.out.close();
        ContextDestroyedEvent destroyedEvent = this.waitForEvent(ContextDestroyedEvent.class, 2000, () -> ((ContextListener)this.testedObject).contextDestroyed(null));
        Assert.assertNotNull((String)"The method contextInitialized() should throw an event!", (Object)destroyedEvent);
    }

    @Test
    public void testServiceName() {
        Assert.assertNotNull((String)"The method getServiceName() should return a proper string!", (Object)((MockedContextListener)((Object)this.testedObject)).getServiceName());
    }

    @Test
    public void testSubmitterClasses() {
        Assert.assertFalse((String)"The method getSubmitterClasses() is supposed to return a non-empty list of classe!", (boolean)((MockedContextListener)((Object)this.testedObject)).getLoaderClasses().isEmpty());
    }
}

