/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.MainContextUtils;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.etls.events.GetETLManagerEvent;
import de.gerdiproject.harvest.etls.events.GetRepositoryNameEvent;
import de.gerdiproject.harvest.etls.json.ETLInfosJson;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.events.CreateLoaderEvent;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import javax.servlet.annotation.WebListener;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractContextListenerTest<T extends ContextListener>
extends AbstractObjectUnitTest<T> {
    protected final Class<T> contextListenerClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    protected File getConfigFile() {
        return this.getResource("config.json");
    }

    protected File getMockedHttpResponseFolder() {
        return this.getResource("mockedHttpResponses");
    }

    @Override
    protected T setUpTestObjects() {
        File configFileResource;
        ContextListener contextListener;
        try {
            contextListener = (ContextListener)this.contextListenerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(this.contextListenerClass.getSimpleName() + " must have a no-args constructor!", e);
        }
        File httpFolderResource = this.getMockedHttpResponseFolder();
        if (httpFolderResource != null && httpFolderResource.exists()) {
            File httpFolderTemp = new File(MainContextUtils.getCacheDirectory(this.getClass()), "savedHttpResponses");
            FileUtils.copyFile((File)httpFolderResource, (File)httpFolderTemp);
        }
        if ((configFileResource = this.getConfigFile()) != null && configFileResource.exists()) {
            File configFile = MainContextUtils.getConfigurationFile((String)contextListener.getServiceName(), contextListener.getClass());
            FileUtils.copyFile((File)configFileResource, (File)configFile);
        }
        return (T)contextListener;
    }

    protected int getMaxInitializationTime() {
        return 5000;
    }

    protected void initContext() {
        this.waitForEvent(ServiceInitializedEvent.class, this.getMaxInitializationTime(), () -> ((ContextListener)this.testedObject).contextInitialized(null));
    }

    @Test
    public void testWebListenerAnnotation() {
        WebListener webListenerAnnotation = ((ContextListener)this.testedObject).getClass().getAnnotation(WebListener.class);
        Assert.assertNotNull((String)"The ContextListener implementation must have a @WebListener annotation!", (Object)webListenerAnnotation);
    }

    @Test
    public void testCreateEtls() {
        this.initContext();
        ETLManager etlManager = (ETLManager)EventSystem.sendSynchronousEvent((ISynchronousEvent)new GetETLManagerEvent());
        ETLInfosJson etlInfos = etlManager.getETLsAsJson();
        Map etlInfoMap = etlInfos.getEtlInfos();
        Assert.assertNotEquals((String)"Expected at least one ETL to be initializable!", (long)0L, (long)etlInfoMap.size());
    }

    @Test
    public void testGetRepositoryName() {
        this.initContext();
        String repositoryName = (String)EventSystem.sendSynchronousEvent((ISynchronousEvent)new GetRepositoryNameEvent());
        Assert.assertNotEquals((String)"Expected the method getRepositoryName() to return a non-empty String!", (long)0L, (long)repositoryName.length());
    }

    @Test
    public void testGetLoaderClasses() {
        this.initContext();
        ILoader loader = (ILoader)EventSystem.sendSynchronousEvent((ISynchronousEvent)new CreateLoaderEvent());
        Assert.assertNotNull((String)"Expected the method createLoaderClasses() to return a non-empty List of Loaders!", (Object)loader);
    }
}

