/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest;

import ch.qos.logback.classic.Level;
import de.gerdiproject.harvest.application.MainContext;
import de.gerdiproject.harvest.application.MainContextUtils;
import de.gerdiproject.harvest.application.enums.DeploymentType;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.Procedure;
import de.gerdiproject.harvest.utils.file.FileUtils;
import de.gerdiproject.harvest.utils.logger.constants.LoggerConstants;
import java.io.File;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractUnitTest {
    protected static final String MODULE_NAME = "UnitTestModule";
    protected static final int DEFAULT_EVENT_TIMEOUT = 2000;
    protected final Random random = new Random();
    private static final String EXPECTED_EVENT_FAIL_MESSAGE = "Expected the %s to be sent before %d ms have passed!";
    private final Level initialLogLevel = LoggerConstants.ROOT_LOGGER.getLevel();

    protected File getTemporaryTestDirectory() {
        return new File(MainContextUtils.getCacheDirectory(this.getClass()), this.getClass().getSimpleName());
    }

    protected File getResourceDirectory() {
        File resourceRoot = new File(MainContextUtils.getProjectRootDirectory(this.getClass()), "src/test/resources");
        return new File(resourceRoot, this.getClass().getName().replace('.', '/'));
    }

    protected final File getResource(String resourceName) {
        return new File(this.getResourceDirectory(), resourceName);
    }

    @Before
    public void before() throws InstantiationException {
        File tempDir = MainContextUtils.getCacheDirectory(this.getClass());
        FileUtils.deleteFile((File)tempDir);
        if (tempDir.exists()) {
            throw new InstantiationException();
        }
        this.setLoggerEnabled(this.isLoggingEnabledDuringTests());
    }

    @After
    public void after() {
        EventSystem.reset();
        MainContext.destroy();
        this.setLoggerEnabled(true);
        File tempDir = MainContextUtils.getCacheDirectory(this.getClass());
        FileUtils.deleteFile((File)tempDir);
    }

    protected void setLoggerEnabled(boolean state) {
        Level newLevel = state ? this.initialLogLevel : Level.OFF;
        LoggerConstants.ROOT_LOGGER.setLevel(newLevel);
    }

    protected boolean isLoggingEnabledDuringTests() {
        return false;
    }

    protected <E extends IEvent> E waitForEvent(Class<E> eventClass, int timeout, Procedure startAction) {
        Object[] receivedEvent = new Object[1];
        Consumer<IEvent> onEventReceived = event -> {
            receivedEvent[0] = event;
        };
        EventSystem.addListener(eventClass, onEventReceived);
        try {
            CancelableFuture asyncProcess = new CancelableFuture(() -> {
                startAction.run();
                for (int passedTime = 0; passedTime < timeout; passedTime += 100) {
                    if (receivedEvent[0] != null) {
                        return true;
                    }
                    Thread.sleep(100L);
                }
                return false;
            });
            CompletableFuture.allOf(new CompletableFuture[]{asyncProcess}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            receivedEvent[0] = null;
        }
        EventSystem.removeListener(eventClass, onEventReceived);
        if (receivedEvent[0] == null) {
            Assert.fail((String)String.format(EXPECTED_EVENT_FAIL_MESSAGE, eventClass.getSimpleName(), timeout));
            return null;
        }
        return (E)((IEvent)receivedEvent[0]);
    }

    static {
        System.setProperty("DEPLOYMENT_TYPE", DeploymentType.UNIT_TEST.toString());
    }
}

