/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest;

import de.gerdiproject.harvest.AbstractObjectUnitTest;
import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.ContextListenerTestWrapper;
import de.gerdiproject.harvest.application.MainContextUtils;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.events.GetConfigurationEvent;
import de.gerdiproject.harvest.etls.AbstractIteratorETL;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.File;

public abstract class AbstractETLUnitTest<T, R>
extends AbstractObjectUnitTest<T> {
    protected abstract AbstractIteratorETL<R, ?> getEtl();

    protected abstract T setUpTestedObjectFromContextInitializer(ContextListenerTestWrapper<? extends AbstractIteratorETL<R, ?>> var1);

    @Override
    protected T setUpTestObjects() {
        File httpResourceFolder = this.getMockedHttpResponseFolder();
        if (httpResourceFolder != null && httpResourceFolder.exists()) {
            File httpCacheFolder = new File(MainContextUtils.getCacheDirectory(this.getClass()), "savedHttpResponses");
            FileUtils.copyFile((File)httpResourceFolder, (File)httpCacheFolder);
        }
        ContextListenerTestWrapper<AbstractIteratorETL> contextInitializer = new ContextListenerTestWrapper<AbstractIteratorETL>(this.getContextListener(), this::getEtl);
        File configFileResource = this.getConfigFile();
        if (configFileResource != null && configFileResource.exists()) {
            File configFile = contextInitializer.getConfigFile();
            FileUtils.copyFile((File)configFileResource, (File)configFile);
        }
        this.waitForEvent(ServiceInitializedEvent.class, this.getMaxInitializationTime(), () -> contextInitializer.initializeContext());
        this.config = (Configuration)EventSystem.sendSynchronousEvent((ISynchronousEvent)new GetConfigurationEvent());
        return this.setUpTestedObjectFromContextInitializer(contextInitializer);
    }

    protected abstract ContextListener getContextListener();

    protected File getConfigFile() {
        return this.getResource("config.json");
    }

    protected File getMockedHttpResponseFolder() {
        return this.getResource("mockedHttpResponses");
    }

    protected int getMaxInitializationTime() {
        return 5000;
    }
}

