/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static void deleteFile(File deletedFile) {
        if (deletedFile.exists()) {
            boolean wasDeleted;
            IOException ioException = null;
            if (deletedFile.isDirectory()) {
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(deletedFile.toPath());){
                    for (Path fileInDir : dirStream) {
                        FileUtils.deleteFile(fileInDir.toFile());
                    }
                }
                catch (IOException e) {
                    wasDeleted = false;
                    ioException = e;
                }
            }
            if (wasDeleted = deletedFile.delete()) {
                LOGGER.trace(String.format("Deleted file '%s'.", deletedFile.getPath()));
            } else if (ioException == null) {
                LOGGER.error(String.format("Could not delete file '%s'!", deletedFile.getPath()));
            } else {
                LOGGER.error(String.format("Could not delete file '%s'!", deletedFile.getPath()), (Throwable)ioException);
            }
        }
    }

    public static void replaceFile(File targetFile, File newFile) {
        if (!newFile.exists()) {
            LOGGER.error(String.format("Could not replace file '%s' with '%s', because it does not exist!", targetFile.getPath(), newFile.getPath()));
            return;
        }
        File backup = null;
        if (targetFile.exists() && !targetFile.renameTo(backup = new File(targetFile.getPath() + ".tmp"))) {
            LOGGER.error(String.format("Could not replace file '%s' with '%s', because a backup file could not be created!", targetFile.getPath(), newFile.getPath()));
            return;
        }
        if (!FileUtils.createDirectories(targetFile.getParentFile())) {
            LOGGER.error(String.format("Could not replace file '%s' with '%s': The target directory does not exist and could not be created!", targetFile.getPath(), newFile.getPath()));
            if (backup != null && !backup.renameTo(targetFile)) {
                LOGGER.error(String.format("Could not restore backup file '%s'!", targetFile.getPath()));
            }
            return;
        }
        if (newFile.renameTo(targetFile)) {
            LOGGER.trace(String.format("Replaced file '%s' with '%s'.", targetFile.getPath(), newFile.getPath()));
            if (backup != null) {
                FileUtils.deleteFile(backup);
            }
        } else {
            LOGGER.error(String.format("Could not replace file '%s' with '%s'!", targetFile.getPath(), newFile.getPath()));
            if (backup != null && !backup.renameTo(targetFile)) {
                LOGGER.error(String.format("Could not restore backup file '%s'!", targetFile.getPath()));
            }
        }
    }

    public static void copyFile(File sourceFile, File targetFile) {
        if (sourceFile.exists() && FileUtils.createDirectories(sourceFile.isDirectory() ? targetFile : targetFile.getParentFile())) {
            block22: {
                if (sourceFile.isDirectory()) {
                    try (DirectoryStream<Path> sourceStream = Files.newDirectoryStream(sourceFile.toPath());){
                        for (Path sourceFilePath : sourceStream) {
                            File sourceDirContent = sourceFilePath.toFile();
                            File targetDirContent = new File(targetFile, sourceDirContent.getName());
                            if (sourceDirContent.isDirectory()) {
                                FileUtils.copyFile(sourceDirContent, targetDirContent);
                                continue;
                            }
                            Files.copy(sourceDirContent.toPath(), targetDirContent.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        break block22;
                    }
                    catch (IOException e) {
                        LOGGER.error(String.format("Could not copy file '%s' to '%s'!", sourceFile.getPath(), targetFile.getPath()), (Throwable)e);
                        return;
                    }
                }
                try {
                    Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.error(String.format("Could not copy file '%s' to '%s'!", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath()), (Throwable)e);
                    return;
                }
            }
            LOGGER.trace(String.format("Copied file '%s' to '%s'.", sourceFile.getPath(), targetFile.getPath()));
        } else if (!sourceFile.exists()) {
            LOGGER.error(String.format("Could not copy file '%s' to '%s', because it does not exist!", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath()));
        }
    }

    public static boolean createDirectories(File directory) {
        if (directory == null || directory.exists()) {
            return true;
        }
        boolean creationSuccessful = directory.mkdirs();
        if (creationSuccessful) {
            LOGGER.trace(String.format("Created directory '%s'.", directory.getPath()));
        } else {
            LOGGER.error(String.format("Could not create directory '%s'!", directory.getPath()));
        }
        return creationSuccessful;
    }

    public static void createEmptyFile(File file) {
        FileUtils.deleteFile(file);
        boolean creationSuccessful = FileUtils.createDirectories(file.getParentFile());
        IOException ioException = null;
        try {
            creationSuccessful &= file.createNewFile();
        }
        catch (IOException e) {
            creationSuccessful = false;
            ioException = e;
        }
        if (creationSuccessful) {
            LOGGER.trace(String.format("Created file '%s'.", file.getPath()));
        } else if (ioException == null) {
            LOGGER.error(String.format("Could not create file '%s'!", file.getPath()));
        } else {
            LOGGER.error(String.format("Could not create file '%s'!", file.getPath()), (Throwable)ioException);
        }
    }

    public static void integrateDirectory(File sourceDirectory, File targetDirectory, boolean replaceFiles) {
        if (!sourceDirectory.exists()) {
            LOGGER.error(String.format("Could not merge '%s' into '%s': The source directory does not exist!", sourceDirectory.getPath(), targetDirectory.getPath()));
            return;
        }
        if (!sourceDirectory.isDirectory() || targetDirectory.exists() && !targetDirectory.isDirectory()) {
            LOGGER.error(String.format("Could not merge '%s' into '%s': Both paths must denote directories!", sourceDirectory.getPath(), targetDirectory.getPath()));
            return;
        }
        if (!targetDirectory.exists()) {
            FileUtils.replaceFile(targetDirectory, sourceDirectory);
            return;
        }
        try (DirectoryStream<Path> sourceStream = Files.newDirectoryStream(sourceDirectory.toPath());){
            for (Path sourceFilePath : sourceStream) {
                File sourceFile = sourceFilePath.toFile();
                File targetFile = new File(targetDirectory, sourceFile.getName());
                if (sourceFile.isDirectory()) {
                    FileUtils.integrateDirectory(sourceFile, targetFile, replaceFiles);
                    continue;
                }
                if (!replaceFiles && targetFile.exists()) continue;
                FileUtils.replaceFile(targetFile, sourceFile);
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not merge '%s' into '%s'!", sourceDirectory.getPath(), targetDirectory.getPath()), (Throwable)e);
            return;
        }
        LOGGER.trace(String.format("Merged folder '%s' into '%s'.", sourceDirectory.getPath(), targetDirectory.getPath()));
        FileUtils.deleteFile(sourceDirectory);
    }

    public static BufferedReader getReader(String filePath, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), charset));
    }

    public static BufferedReader getReader(File file, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));
    }

    public static BufferedWriter getWriter(String filePath, Charset charset) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), charset));
    }

    public static BufferedWriter getWriter(File file, Charset charset) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), charset));
    }

    private FileUtils() {
    }
}

