/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler.utils;

import de.gerdiproject.harvest.scheduler.enums.CronMonth;
import de.gerdiproject.harvest.scheduler.enums.CronWeekDay;
import de.gerdiproject.harvest.scheduler.utils.CronUtils;
import java.util.Arrays;
import java.util.TreeSet;

public class CronParser {
    public static byte[] parseMinutes(String cronTabMinutes) throws IllegalArgumentException {
        return CronParser.parseCronField(cronTabMinutes, 0, 59);
    }

    public static byte[] parseHours(String cronTabHours) throws IllegalArgumentException {
        return CronParser.parseCronField(cronTabHours, 0, 23);
    }

    public static byte[] parseMonthDays(String cronTabMonthDays) throws IllegalArgumentException {
        return CronParser.parseCronField(cronTabMonthDays, 1, 31);
    }

    public static byte[] parseWeekDays(String cronTabWeekDays) throws IllegalArgumentException {
        byte[] weekDays = CronParser.parseCronField(cronTabWeekDays, 0, 7);
        if (weekDays[weekDays.length - 1] == 7) {
            byte[] weekDaysWithoutSeven;
            if (weekDays[0] == 0) {
                weekDaysWithoutSeven = new byte[weekDays.length - 1];
                System.arraycopy(weekDays, 0, weekDaysWithoutSeven, 0, weekDaysWithoutSeven.length);
            } else {
                weekDaysWithoutSeven = new byte[weekDays.length];
                System.arraycopy(weekDays, 0, weekDaysWithoutSeven, 1, weekDays.length - 1);
            }
            return weekDaysWithoutSeven;
        }
        return weekDays;
    }

    public static byte[] parseMonths(String cronTabMonths, byte[] monthDays, byte[] weekDays) throws IllegalArgumentException {
        boolean isWeekDayUnRestricted;
        byte[] months = CronParser.parseCronField(cronTabMonths, 1, 12);
        boolean bl = isWeekDayUnRestricted = weekDays[0] == 0 && weekDays[weekDays.length - 1] == 6;
        if (isWeekDayUnRestricted && (months = CronParser.removeInvalidMonths(monthDays, months)).length == 0) {
            throw new IllegalArgumentException(String.format("Invalid cron month restriction '%s': The restriction of days and months causes this job to never be executed!", cronTabMonths));
        }
        return months;
    }

    private static byte[] removeInvalidMonths(byte[] days, byte[] months) {
        byte earliestDay = days[0];
        if (earliestDay <= 29) {
            return months;
        }
        int removedCount = 0;
        for (int i = 0; i < months.length; ++i) {
            if (CronUtils.getDaysInMonth(months[i], 2016) >= earliestDay) continue;
            months[i] = -1;
            ++removedCount;
        }
        if (removedCount == 0) {
            return months;
        }
        if (removedCount == months.length) {
            return new byte[0];
        }
        Arrays.sort(months);
        byte[] culledMonths = new byte[months.length - removedCount];
        System.arraycopy(months, removedCount, culledMonths, 0, months.length - removedCount);
        return culledMonths;
    }

    private static byte[] parseCronField(String field, int minVal, int maxVal) throws IllegalArgumentException {
        byte[] values = "*".equals(field) ? CronParser.parseAllValuesField(minVal, maxVal) : (field.contains(",") ? CronParser.parseMultiValueField(field, minVal, maxVal) : (field.contains("/") ? CronParser.parseFrequencyField(field, minVal, maxVal) : (field.contains("-") ? CronParser.parseRangeField(field, minVal, maxVal) : new byte[]{CronParser.parseSingleValueField(field, minVal, maxVal)})));
        return values;
    }

    private static byte parseSingleValueField(String field, int minVal, int maxVal) throws IllegalArgumentException {
        byte singleValue = -1;
        try {
            singleValue = Byte.parseByte(field);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (singleValue == -1) {
            try {
                singleValue = (byte)CronMonth.valueOf(field).ordinal();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (singleValue == -1) {
            try {
                singleValue = (byte)CronWeekDay.valueOf(field).ordinal();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse cron field '%s'!", field));
            }
        }
        if (singleValue < minVal || singleValue > maxVal) {
            throw new IllegalArgumentException(String.format("Cron field '%s' out of range [%d, %d]!", field, minVal, maxVal));
        }
        return singleValue;
    }

    private static byte[] parseAllValuesField(int minVal, int maxVal) {
        int len = 1 + maxVal - minVal;
        byte[] values = new byte[len];
        for (int i = 0; i < len; ++i) {
            values[i] = (byte)(minVal + i);
        }
        return values;
    }

    private static byte[] parseFrequencyField(String field, int minVal, int maxVal) throws IllegalArgumentException {
        try {
            String[] frequency = field.split("/");
            if (frequency.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid frequency in cron field '%s'!", field));
            }
            byte[] freqRange = CronParser.parseCronField(frequency[0], minVal, maxVal);
            byte freqInterval = CronParser.parseSingleValueField(frequency[1], minVal, maxVal);
            byte freqRangeFrom = freqRange[0];
            int freqRangeTo = freqRange.length == 1 ? maxVal : freqRange[freqRange.length - 1];
            int len = 1 + (freqRangeTo - freqRangeFrom) / freqInterval;
            byte[] values = new byte[len];
            for (int i = 0; i < len; ++i) {
                values[i] = (byte)(freqRangeFrom + i * freqInterval);
            }
            return values;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid frequency in cron field '%s'!", field));
        }
    }

    private static byte[] parseRangeField(String field, int minVal, int maxVal) {
        String[] range = field.split("-");
        if (range.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid range in cron field '%s'!", field));
        }
        byte rangeFrom = CronParser.parseSingleValueField(range[0], minVal, maxVal);
        byte rangeTo = CronParser.parseSingleValueField(range[1], minVal, maxVal);
        return CronParser.parseAllValuesField(rangeFrom, rangeTo);
    }

    private static byte[] parseMultiValueField(String field, int minVal, int maxVal) {
        String[] subFields;
        TreeSet<Byte> tempValues = new TreeSet<Byte>();
        for (String subField : subFields = field.split(",")) {
            byte[] subValues;
            for (byte subValue : subValues = CronParser.parseCronField(subField, minVal, maxVal)) {
                tempValues.add(subValue);
            }
        }
        int i = 0;
        byte[] values = new byte[tempValues.size()];
        for (Byte v : tempValues) {
            values[i++] = v;
        }
        return values;
    }

    private CronParser() {
    }
}

