/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.utils;

import java.time.Instant;

public final class TimestampedEntry<T> {
    private final T value;
    private final long timestamp;

    public TimestampedEntry(T value) {
        this(value, System.currentTimeMillis());
    }

    public String toString() {
        return this.value.toString() + " since " + Instant.ofEpochMilli(this.timestamp);
    }

    public T getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampedEntry)) {
            return false;
        }
        TimestampedEntry other = (TimestampedEntry)o;
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public TimestampedEntry(T value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }
}

