/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import de.gerdiproject.harvest.application.events.ResetContextEvent;
import de.gerdiproject.harvest.etls.enums.ETLHealth;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.events.GetETLManagerEvent;
import de.gerdiproject.harvest.etls.json.ETLInfosJson;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.rest.AbstractRestResource;
import de.gerdiproject.harvest.rest.HttpResponseFactory;
import de.gerdiproject.harvest.utils.logger.HarvesterLog;
import de.gerdiproject.harvest.utils.logger.events.GetMainLogEvent;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import de.gerdiproject.harvest.utils.maven.events.GetMavenUtilsEvent;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="")
public class ETLRestResource
extends AbstractRestResource<ETLManager, GetETLManagerEvent> {
    @GET
    @Path(value="etl")
    @Produces(value={"application/json"})
    public Response getETLInfo(@Context UriInfo uriInfo) {
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        try {
            ETLJson responseObject = ((ETLManager)this.restObject).getETLAsJson((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
            return HttpResponseFactory.createOkResponse(this.gson.toJsonTree((Object)responseObject));
        }
        catch (RuntimeException e) {
            return HttpResponseFactory.createBadRequestResponse(e.getMessage());
        }
    }

    @GET
    @Path(value="etls")
    @Produces(value={"application/json"})
    public Response getAllETLInfos() {
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        try {
            ETLInfosJson responseObject = ((ETLManager)this.restObject).getETLsAsJson();
            return HttpResponseFactory.createOkResponse(this.gson.toJsonTree((Object)responseObject));
        }
        catch (RuntimeException e) {
            return HttpResponseFactory.createBadRequestResponse(e.getMessage());
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response startHarvest(MultivaluedMap<String, String> formParams) {
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        try {
            ((ETLManager)this.restObject).harvest();
            return HttpResponseFactory.createAcceptedResponse("Harvest started!");
        }
        catch (IllegalStateException e) {
            return HttpResponseFactory.createBusyResponse(e.getMessage(), ((ETLManager)this.restObject).estimateRemainingHarvestTime() / 1000L);
        }
        catch (RuntimeException e) {
            return HttpResponseFactory.createBadRequestResponse(e.getMessage());
        }
    }

    @GET
    @Path(value="outdated")
    @Produces(value={"application/json"})
    public Response checkIfEtlIssOutdated() {
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        return HttpResponseFactory.createValueResponse(Response.Status.OK, (JsonElement)new JsonPrimitive(Boolean.valueOf(((ETLManager)this.restObject).hasOutdatedETLs())));
    }

    @POST
    @Path(value="abort")
    @Produces(value={"application/json"})
    public Response abort() {
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        if (((ETLManager)this.restObject).getState() == ETLState.HARVESTING) {
            ((ETLManager)this.restObject).abortHarvest();
            return HttpResponseFactory.createAcceptedResponse("Aborting harvest...");
        }
        return HttpResponseFactory.createBadRequestResponse("Cannot abort harvest: No harvest is currently running!");
    }

    @POST
    @Path(value="reset")
    @Produces(value={"application/json"})
    public Response reset() {
        EventSystem.sendEvent(new ResetContextEvent());
        return HttpResponseFactory.createAcceptedResponse("Resetting the Harvester Service!");
    }

    @GET
    @Path(value="log")
    @Produces(value={"text/plain"})
    public Response getLog(@QueryParam(value="date") String dateString, @QueryParam(value="level") String levelString, @QueryParam(value="class") String classString) {
        List<String> classFilters;
        List<String> levelFilters;
        HarvesterLog mainLog = (HarvesterLog)EventSystem.sendSynchronousEvent(new GetMainLogEvent());
        if (mainLog == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        List<String> dateFilters = dateString == null ? null : Arrays.asList(dateString.split(","));
        String log = mainLog.getLog(dateFilters, levelFilters = levelString == null ? null : Arrays.asList(levelString.split(",")), classFilters = classString == null ? null : Arrays.asList(classString.split(",")));
        if (log == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        return HttpResponseFactory.createPlainTextOkResponse(log);
    }

    @POST
    @Path(value="log/_delete")
    @Produces(value={"application/json"})
    public Response clearLog() {
        HarvesterLog mainLog = (HarvesterLog)EventSystem.sendSynchronousEvent(new GetMainLogEvent());
        if (mainLog == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        mainLog.clearLog();
        return HttpResponseFactory.createOkResponse("Log has been deleted.");
    }

    @GET
    @Path(value="health")
    @Produces(value={"application/json"})
    public Response getHealth() {
        if (this.restObject == null) {
            return HttpResponseFactory.createValueResponse(Response.Status.INTERNAL_SERVER_ERROR, (JsonElement)new JsonPrimitive(ETLHealth.INITIALIZATION_FAILED.toString()));
        }
        ETLHealth health = ((ETLManager)this.restObject).getHealth();
        Response.Status status = health == ETLHealth.OK ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return HttpResponseFactory.createValueResponse(status, (JsonElement)new JsonPrimitive(health.toString()));
    }

    @GET
    @Path(value="versions")
    @Produces(value={"application/json"})
    public Response getVersions() {
        return HttpResponseFactory.createValueResponse(Response.Status.OK, (JsonElement)this.getSpecifiedVersions("de.gerdi-project"));
    }

    @GET
    @Path(value="versions-all")
    @Produces(value={"application/json"})
    public Response getAllVersions() {
        return HttpResponseFactory.createValueResponse(Response.Status.OK, (JsonElement)this.getSpecifiedVersions(null));
    }

    private JsonArray getSpecifiedVersions(String filter) {
        MavenUtils utils = (MavenUtils)EventSystem.sendSynchronousEvent(new GetMavenUtilsEvent());
        if (utils == null) {
            return null;
        }
        String mainJar = utils.getHarvesterJarName();
        if (mainJar == null) {
            return null;
        }
        List<String> dependencyList = utils.getMavenVersionInfo(filter);
        if (dependencyList == null) {
            return null;
        }
        dependencyList.remove(mainJar);
        JsonArray array = new JsonArray();
        dependencyList.forEach(d -> array.add(d));
        return array;
    }

    @Override
    protected String getAllowedRequests() {
        return "GET\nRetrieves the generic harvest information as a JSON object, or as plain text if the query parameter ?pretty is added.\n\nGET /etls\nReturns detailed information about all ETLs.\n\nGET /etl?name=XXX\nReturns detailed information about an ETL with the name 'XXX'.\nThe query parameter 'name' must be the name of the ETL.\n\nGET /health\nReturns plain text that serves as a health check.\n\nGET /outdated\nChecks if there is unharvested metadata.\n\nGET /config\nDisplays parameters and a means of configuring them.\n\nGET /schedule\nDisplays a configurable set of cron jobs that can trigger harvests automatically.\n\nGET /log\nDisplays the server log. The query parameters 'date', 'class', and 'level' can be used to filter the log with comma-separated values of dates, logger classes, and log levels.\n\nGET /versions\nReturns a list of GeRDI Maven dependencies.\n\nGET /versions-all\nReturns a list of all Maven dependencies.\n\nPOST\nStarts the harvest.\n\nPOST /abort\nAborts an ongoing harvest.\n\nPOST /reset\nAttempts to re-initialize this service.";
    }
}

