/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.loaders.AbstractIteratorLoader;
import de.gerdiproject.harvest.etls.loaders.LoaderException;
import de.gerdiproject.harvest.etls.loaders.constants.LoaderConstants;
import de.gerdiproject.harvest.utils.HashGenerator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractURLLoader<S extends IDocument>
extends AbstractIteratorLoader<S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, IDocument> batchMap = new HashMap<String, IDocument>();
    protected final IntegerParameter maxBatchSizeParam;
    protected final StringParameter urlParam = Configuration.registerParameter(LoaderConstants.URL_PARAM);
    protected final HashGenerator hashGenerator;
    protected volatile Charset charset;
    private final StringParameter userNameParam = Configuration.registerParameter(LoaderConstants.USER_NAME_PARAM);
    private final StringParameter passwordParam = Configuration.registerParameter(LoaderConstants.PASSWORD_PARAM);
    private int currentBatchSize;

    public AbstractURLLoader() {
        this.maxBatchSizeParam = Configuration.registerParameter(LoaderConstants.MAX_BATCH_SIZE_PARAM);
        this.hashGenerator = new HashGenerator(StandardCharsets.UTF_8);
    }

    @Override
    public void unregisterParameters() {
        Configuration.unregisterParameter(this.urlParam);
        Configuration.unregisterParameter(this.userNameParam);
        Configuration.unregisterParameter(this.passwordParam);
        Configuration.unregisterParameter(this.maxBatchSizeParam);
    }

    @Override
    public void init(AbstractETL<?, ?> etl) {
        super.init(etl);
        this.batchMap.clear();
        this.currentBatchSize = 0;
        this.charset = etl.getCharset();
        String errorMessage = this.checkPreconditionErrors();
        if (errorMessage != null) {
            throw new IllegalStateException(errorMessage);
        }
    }

    @Override
    public void load(Iterator<S> documents) throws LoaderException {
        super.load(documents);
        if (!this.batchMap.isEmpty()) {
            this.tryLoadingBatch();
            this.batchMap.clear();
        }
    }

    @Override
    public void loadElement(S document) throws LoaderException {
        if (document == null) {
            return;
        }
        String documentId = this.hashGenerator.getShaHash(document.getSourceId());
        int documentSize = this.getSizeOfDocument(documentId, (IDocument)document);
        if (this.currentBatchSize == 0 && documentSize > (Integer)this.maxBatchSizeParam.getValue()) {
            throw new LoaderException(String.format("Loader Error: Size of document %s is %d bytes, which is larger than the maximum permitted size of %d bytes.", documentId, documentSize, this.maxBatchSizeParam.getValue()));
        }
        if (this.currentBatchSize + documentSize > (Integer)this.maxBatchSizeParam.getValue()) {
            this.tryLoadingBatch();
            this.batchMap.clear();
            this.currentBatchSize = 0;
        }
        this.batchMap.put(documentId, (IDocument)document);
        this.currentBatchSize += documentSize;
    }

    @Override
    public void clear() {
        if (!this.batchMap.isEmpty()) {
            try {
                this.tryLoadingBatch();
            }
            catch (LoaderException e) {
                this.logger.warn("Loader Error: Unable to submit partially harvested documents while cancelling the harvest!", (Throwable)e);
            }
            this.batchMap.clear();
        }
        this.currentBatchSize = 0;
    }

    protected abstract int getSizeOfDocument(String var1, IDocument var2);

    protected abstract void loadBatch(Map<String, IDocument> var1);

    protected String checkPreconditionErrors() {
        String url = this.getUrl();
        if (url == null || url.isEmpty()) {
            return "Loader Error: You need to set up a valid loader URL!";
        }
        return null;
    }

    protected void tryLoadingBatch() throws LoaderException {
        int numberOfDocs = this.batchMap.size();
        try {
            this.loadBatch(this.batchMap);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Loaded %d documents.", numberOfDocs));
            }
        }
        catch (RuntimeException e) {
            throw new LoaderException(e);
        }
    }

    protected String getCredentials() {
        if (this.userNameParam.getValue() == null || this.passwordParam.getValue() == null || ((String)this.userNameParam.getValue()).isEmpty()) {
            return null;
        }
        return Base64.getEncoder().encodeToString(((String)this.userNameParam.getValue() + ":" + (String)this.passwordParam.getValue()).getBytes(StandardCharsets.UTF_8));
    }

    protected String getUrl() {
        return this.urlParam.getStringValue();
    }
}

