/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.AbstractIteratorETL;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.LoaderException;
import de.gerdiproject.harvest.etls.loaders.constants.LoaderConstants;
import de.gerdiproject.harvest.etls.transformers.TransformerException;
import java.util.Iterator;

public abstract class AbstractIteratorLoader<S>
implements ILoader<Iterator<S>> {
    protected AbstractIteratorETL<?, ?> dedicatedEtl;
    protected boolean hasLoadedDocuments;

    @Override
    public void init(AbstractETL<?, ?> etl) {
        if (!(etl instanceof AbstractIteratorETL)) {
            throw new IllegalStateException(String.format(LoaderConstants.NO_ITER_ETL_ERROR, this.getClass().getSimpleName()));
        }
        this.dedicatedEtl = (AbstractIteratorETL)etl;
        this.hasLoadedDocuments = false;
    }

    @Override
    public void load(Iterator<S> documents) throws LoaderException {
        while (documents.hasNext() && this.dedicatedEtl.getState() == ETLState.HARVESTING) {
            S next = documents.next();
            this.loadElementAndIncrement(next);
        }
    }

    protected void loadElementAndIncrement(S document) throws LoaderException {
        if (document == null) {
            this.dedicatedEtl.incrementHarvestedDocuments();
            return;
        }
        try {
            this.loadElement(document);
            this.hasLoadedDocuments = true;
        }
        catch (ExtractorException | LoaderException | TransformerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new LoaderException(e);
        }
        finally {
            this.dedicatedEtl.incrementHarvestedDocuments();
        }
    }

    protected abstract void loadElement(S var1) throws LoaderException;
}

