/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.events;

import de.gerdiproject.harvest.event.AbstractSucceededOrFailedEvent;
import java.time.Instant;

public final class HarvestFinishedEvent
extends AbstractSucceededOrFailedEvent {
    private final String documentChecksum;
    private final long endTimestamp;

    public HarvestFinishedEvent(boolean isSuccessful, String documentChecksum) {
        super(isSuccessful);
        this.documentChecksum = documentChecksum;
        this.endTimestamp = Instant.now().toEpochMilli();
    }

    public HarvestFinishedEvent(boolean isSuccessful, String documentChecksum, long timestamp) {
        super(isSuccessful);
        this.documentChecksum = documentChecksum;
        this.endTimestamp = timestamp;
    }

    public String getDocumentChecksum() {
        return this.documentChecksum;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarvestFinishedEvent)) {
            return false;
        }
        HarvestFinishedEvent other = (HarvestFinishedEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$documentChecksum = this.getDocumentChecksum();
        String other$documentChecksum = other.getDocumentChecksum();
        if (this$documentChecksum == null ? other$documentChecksum != null : !this$documentChecksum.equals(other$documentChecksum)) {
            return false;
        }
        return this.getEndTimestamp() == other.getEndTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HarvestFinishedEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $documentChecksum = this.getDocumentChecksum();
        result = result * 59 + ($documentChecksum == null ? 43 : $documentChecksum.hashCode());
        long $endTimestamp = this.getEndTimestamp();
        result = result * 59 + (int)($endTimestamp >>> 32 ^ $endTimestamp);
        return result;
    }

    public String toString() {
        return "HarvestFinishedEvent(super=" + super.toString() + ", documentChecksum=" + this.getDocumentChecksum() + ", endTimestamp=" + this.getEndTimestamp() + ")";
    }
}

