/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters.constants;

import de.gerdiproject.harvest.config.parameters.constants.ParameterConstants;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.events.GetETLManagerEvent;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.event.EventSystem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Function;

public class ParameterMappingFunctions {
    public static String mapToString(String value) {
        return value;
    }

    public static String mapToNonEmptyString(String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("It must be a non-empty string!");
        }
        return value;
    }

    public static Boolean mapToBoolean(String value) throws ClassCastException {
        if (value == null || value.isEmpty()) {
            return false;
        }
        if (ParameterConstants.BOOLEAN_VALID_VALUES_LIST.contains(value)) {
            return value.equals(ParameterConstants.BOOLEAN_VALID_VALUES_LIST.get(0)) || Boolean.parseBoolean(value);
        }
        throw new ClassCastException("Allowed values are: 0, 1, true, false");
    }

    public static Integer mapToInteger(String value) throws ClassCastException {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        if (value.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (value.equals("min")) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(ParameterConstants.INTEGER_ALLOWED_VALUES);
        }
    }

    public static Integer mapToUnsignedInteger(String value) throws ClassCastException {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        if (value.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (value.equals("min")) {
            return 0;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0) {
                throw new IllegalArgumentException("Allowed values are: max, min, 0, 1, ...");
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ClassCastException("Allowed values are: max, min, 0, 1, ...");
        }
    }

    public static String mapToUrlString(String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("It must be a valid URL!");
        }
        return value;
    }

    public static <V> Function<String, V> createMapperForETL(Function<String, V> originalMappingFunction, AbstractETL<?, ?> etl) {
        return value -> {
            ETLState etlStatus = etl.getState();
            switch (etlStatus) {
                case QUEUED: 
                case HARVESTING: 
                case ABORTING: 
                case CANCELLING: {
                    throw new IllegalStateException(String.format("The '%s' must be idle, but it is currently %s!", etl.getName(), etlStatus.toString().toLowerCase(Locale.ENGLISH)));
                }
            }
            return originalMappingFunction.apply((String)value);
        };
    }

    public static <V> Function<String, V> createMapperForETLs(Function<String, V> originalMappingFunction) {
        return value -> {
            ETLManager registry = (ETLManager)EventSystem.sendSynchronousEvent(new GetETLManagerEvent());
            ETLState overallEtlStatus = registry == null ? ETLState.INITIALIZING : registry.getState();
            switch (overallEtlStatus) {
                case QUEUED: 
                case HARVESTING: 
                case ABORTING: 
                case CANCELLING: {
                    throw new IllegalStateException(String.format("All ETLs must be idle, but they are currently %s!", overallEtlStatus.toString().toLowerCase(Locale.ENGLISH)));
                }
            }
            return originalMappingFunction.apply((String)value);
        };
    }

    public static Function<String, String> createStringListMapper(Collection<String> validValues) {
        return value -> {
            if (value == null || value.isEmpty()) {
                return null;
            }
            for (String validVal : validValues) {
                if (!value.equalsIgnoreCase(validVal)) continue;
                return validVal;
            }
            String allowedValuesText = validValues.toString();
            allowedValuesText = allowedValuesText.substring(1, allowedValuesText.length() - 1);
            throw new IllegalArgumentException("Allowed values are: " + allowedValuesText);
        };
    }

    public static Function<String, String> createClassNameListMapper(Collection<Class<?>> validClasses) {
        return value -> {
            if (value == null || value.isEmpty()) {
                return null;
            }
            StringBuilder allowedValuesStringBuilder = new StringBuilder();
            for (Class loaderClass : validClasses) {
                String className = loaderClass.getSimpleName();
                if (className.equalsIgnoreCase((String)value)) {
                    return className;
                }
                if (allowedValuesStringBuilder.length() != 0) {
                    allowedValuesStringBuilder.append(", ");
                }
                allowedValuesStringBuilder.append(className);
            }
            throw new IllegalArgumentException("Allowed values are: " + allowedValuesStringBuilder.toString());
        };
    }

    private ParameterMappingFunctions() {
    }
}

