/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.gerdiproject.harvest.config.events.GetConfigurationEvent;
import de.gerdiproject.harvest.config.events.ParameterChangedEvent;
import de.gerdiproject.harvest.config.events.RegisterParameterEvent;
import de.gerdiproject.harvest.config.events.UnregisterParameterEvent;
import de.gerdiproject.harvest.config.json.adapters.ConfigurationAdapter;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.rest.AbstractRestObject;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.file.ICachedObject;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends AbstractRestObject<Configuration, Configuration>
implements ICachedObject {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Configuration.class, (Object)new ConfigurationAdapter()).create();
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private final transient DiskIO diskIo;
    private transient String cacheFilePath;
    private final Map<String, AbstractParameter<?>> parameterMap;
    private final Consumer<UnregisterParameterEvent> onUnregisterParameterCallback = this::onUnregisterParameter;

    public Configuration(String moduleName, AbstractParameter<?> ... parameters) {
        super(moduleName, GetConfigurationEvent.class);
        this.parameterMap = new TreeMap();
        for (AbstractParameter<?> param : parameters) {
            this.parameterMap.put(param.getCompositeKey(), param);
        }
        this.diskIo = new DiskIO(GSON, StandardCharsets.UTF_8);
        this.cacheFilePath = null;
    }

    public static <T extends AbstractParameter<?>> T registerParameter(T parameter) throws IllegalStateException {
        AbstractParameter registeredParam = (AbstractParameter)EventSystem.sendSynchronousEvent(new RegisterParameterEvent(parameter));
        if (registeredParam == null) {
            throw new IllegalStateException(String.format("Cannot register parameter '%s', because no Configuration with event listeners exists, yet!", parameter.getCompositeKey()));
        }
        return (T)registeredParam;
    }

    public static void unregisterParameter(AbstractParameter<?> parameter) {
        EventSystem.sendEvent(new UnregisterParameterEvent(parameter));
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        EventSystem.addSynchronousListener(RegisterParameterEvent.class, this::onRegisterParameter);
        EventSystem.addListener(UnregisterParameterEvent.class, this.onUnregisterParameterCallback);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        EventSystem.removeSynchronousListener(RegisterParameterEvent.class);
        EventSystem.removeListener(UnregisterParameterEvent.class, this.onUnregisterParameterCallback);
    }

    private String getParameterFormat() {
        int maxLength = 0;
        for (AbstractParameter<?> param : this.parameterMap.values()) {
            int keyLength = param.getKey().length();
            if (keyLength <= maxLength) continue;
            maxLength = keyLength;
        }
        return String.format("%%n%%1$-%ds :  %%2$s", maxLength);
    }

    public void setCacheFilePath(String path) {
        this.cacheFilePath = path;
    }

    @Override
    public void saveToDisk() {
        if (this.cacheFilePath == null) {
            LOGGER.error("Cannot save configuration: You must set a path first!");
        } else {
            this.diskIo.writeObjectToFile(this.cacheFilePath, (Object)this);
        }
    }

    @Override
    public void loadFromDisk() {
        if (this.cacheFilePath == null) {
            LOGGER.error(String.format("Could not load configuration from '%s': %s", "", "You must set a path first!"));
            return;
        }
        Configuration loadedConfig = this.diskIo.getObject(this.cacheFilePath, Configuration.class);
        if (loadedConfig == null) {
            LOGGER.info(String.format("Did not load configuration, because it is not cached at '%s'!", this.cacheFilePath));
            return;
        }
        this.parameterMap.clear();
        this.parameterMap.putAll(loadedConfig.parameterMap);
        for (AbstractParameter<?> param : this.getParameters()) {
            LOGGER.debug(String.format("Loaded %s '%s' with value '%s'.", param.getClass().getSimpleName(), param.getCompositeKey(), param.getStringValue()));
        }
        LOGGER.info(String.format("Loaded configuration from '%s'.", this.cacheFilePath));
    }

    public <T> T getParameterValue(String compositeKey) {
        AbstractParameter<?> param = this.parameterMap.get(compositeKey.toLowerCase(Locale.ENGLISH));
        if (param == null || param.getValue() == null) {
            return null;
        }
        return (T)param.getValue();
    }

    public String getParameterStringValue(String compositeKey) {
        AbstractParameter<?> param = this.parameterMap.get(compositeKey.toLowerCase(Locale.ENGLISH));
        return param == null ? null : param.getStringValue();
    }

    public void setParameter(String compositeKey, String value) throws IllegalArgumentException {
        AbstractParameter<?> param = this.parameterMap.get(compositeKey.toLowerCase(Locale.ENGLISH));
        if (param == null || !param.isRegistered()) {
            throw new IllegalArgumentException(String.format("Cannot change parameter '%s'. Unknown parameter!", compositeKey));
        }
        Object oldValue = param.getValue();
        param.setValue(value);
        Object newValue = param.getValue();
        if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
            EventSystem.sendEvent(new ParameterChangedEvent(param, oldValue));
            LOGGER.debug(String.format("Set parameter '%s' to '%s'.", param.getCompositeKey(), param.getStringValue()));
        }
    }

    public String changeParameters(Map<String, String> values) throws IllegalArgumentException {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Cannot change parameters: Missing request body!");
        }
        boolean hasChanged = false;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> p : values.entrySet()) {
            String feedback;
            if (sb.length() != 0) {
                sb.append('\n');
            }
            try {
                this.setParameter(p.getKey(), p.getValue());
                hasChanged = true;
                feedback = String.format("Set parameter '%s' to '%s'.", p.getKey(), this.getParameterStringValue(p.getKey()));
            }
            catch (IllegalArgumentException e) {
                feedback = e.getMessage();
                LOGGER.warn("", (Throwable)e);
            }
            sb.append(feedback);
        }
        if (!hasChanged) {
            throw new IllegalArgumentException(sb.toString());
        }
        this.saveToDisk();
        return sb.toString();
    }

    public Collection<AbstractParameter<?>> getParameters() {
        return this.parameterMap.values();
    }

    @Override
    protected String getPrettyPlainText() {
        String format = this.getParameterFormat();
        HashMap<String, StringBuilder> categoryStringBuilders = new HashMap<String, StringBuilder>();
        for (AbstractParameter<?> param : this.getParameters()) {
            if (!param.isRegistered()) continue;
            String categoryName2 = param.getCategory();
            if (!categoryStringBuilders.containsKey(categoryName2)) {
                StringBuilder catBuilder = new StringBuilder();
                catBuilder.append(String.format("- %s -", categoryName2));
                categoryStringBuilders.put(categoryName2, catBuilder);
            }
            ((StringBuilder)categoryStringBuilders.get(categoryName2)).append(String.format(format, param.getKey(), param.getStringValue()));
        }
        StringBuilder combinedBuilder = new StringBuilder();
        categoryStringBuilders.forEach((categoryName, categoryString) -> {
            if (combinedBuilder.length() != 0) {
                combinedBuilder.append("\n\n");
            }
            combinedBuilder.append(categoryString.toString());
        });
        return combinedBuilder.toString();
    }

    @Override
    public Configuration getAsJson(MultivaluedMap<String, String> query) {
        return this;
    }

    private <T> AbstractParameter<T> onRegisterParameter(RegisterParameterEvent event) {
        AbstractParameter<?> registeredParameter = event.getParameter();
        String compositeKey = registeredParameter.getCompositeKey();
        AbstractParameter<?> retrievedParameter = this.parameterMap.get(compositeKey);
        if (retrievedParameter == null) {
            registeredParameter = registeredParameter.copy();
            this.parameterMap.put(compositeKey, registeredParameter);
            registeredParameter.loadFromEnvironmentVariables();
            LOGGER.debug(String.format("Added new %s '%s' with value '%s' to the config.", registeredParameter.getClass().getSimpleName(), registeredParameter.getCompositeKey(), registeredParameter.getStringValue()));
            this.saveToDisk();
        } else {
            if (!retrievedParameter.isRegistered()) {
                retrievedParameter.setMappingFunction(registeredParameter.getMappingFunction());
            }
            registeredParameter = retrievedParameter;
        }
        registeredParameter.setRegistered(true);
        return registeredParameter;
    }

    private void onUnregisterParameter(UnregisterParameterEvent event) {
        event.getParameter().setRegistered(false);
    }
}

