/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.application.constants.ApplicationConstants;
import de.gerdiproject.harvest.application.enums.DeploymentType;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.utils.LoaderRegistry;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.utils.logger.HarvesterLog;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import de.gerdiproject.harvest.utils.maven.constants.MavenConstants;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MainContextUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainContextUtils.class);

    protected static DeploymentType initDeploymentType() {
        DeploymentType deploymentType;
        String deploymentTypeSystemProperty = System.getProperty("DEPLOYMENT_TYPE", null);
        if (deploymentTypeSystemProperty == null) {
            deploymentType = DeploymentType.OTHER;
        } else {
            try {
                deploymentType = DeploymentType.valueOf(deploymentTypeSystemProperty.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                deploymentType = DeploymentType.OTHER;
            }
        }
        return deploymentType;
    }

    protected static File initCacheDirectory(DeploymentType deploymentType) {
        String subDirPath;
        String projectRootPath;
        switch (deploymentType) {
            case UNIT_TEST: {
                projectRootPath = MainContextUtils.getProjectRootDirectory();
                subDirPath = "debug/unit-tests/";
                break;
            }
            case JETTY: {
                projectRootPath = MainContextUtils.getProjectRootDirectory();
                subDirPath = "debug/";
                break;
            }
            default: {
                projectRootPath = ApplicationConstants.CACHE_ROOT_DIR_OTHER;
                subDirPath = "";
            }
        }
        return new File(projectRootPath, subDirPath);
    }

    protected static File initLogFile(DeploymentType deploymentType, String moduleName) {
        String logPathFormat;
        switch (deploymentType) {
            case UNIT_TEST: {
                logPathFormat = MainContextUtils.getProjectRootDirectory() + File.separatorChar + "debug/unit-tests/%s.log";
                break;
            }
            case JETTY: {
                logPathFormat = MainContextUtils.getProjectRootDirectory() + File.separatorChar + "debug/%s.log";
                break;
            }
            case DOCKER: {
                logPathFormat = "/var/log/harvester/%s.log";
                break;
            }
            default: {
                logPathFormat = "%s.log";
            }
        }
        return new File(String.format(logPathFormat, moduleName));
    }

    private static String getProjectRootDirectory() {
        String jarPath;
        try {
            jarPath = new File(MainContextUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            return "";
        }
        return jarPath.substring(0, jarPath.lastIndexOf(MavenConstants.TARGET_FOLDER));
    }

    protected static LoaderRegistry createLoaderRegistry(List<Class<? extends ILoader<?>>> loaderClasses) {
        LOGGER.info(String.format("Initializing %s...", LoaderRegistry.class.getSimpleName()));
        LoaderRegistry registry = new LoaderRegistry();
        registry.addEventListeners();
        for (Class<ILoader<?>> clazz : loaderClasses) {
            registry.registerLoader(clazz);
        }
        LOGGER.info(String.format("Successfully initialized %s!", LoaderRegistry.class.getSimpleName()));
        return registry;
    }

    protected static HarvesterLog createLog(File logPath) {
        LOGGER.info(String.format("Initializing %s...", HarvesterLog.class.getSimpleName()));
        HarvesterLog serviceLog = new HarvesterLog(logPath.toString());
        serviceLog.registerLogger();
        LOGGER.info(String.format("Successfully initialized %s!", HarvesterLog.class.getSimpleName()));
        return serviceLog;
    }

    protected static MavenUtils createMavenUtils(Class<?> harvesterClass) {
        LOGGER.info(String.format("Initializing %s...", MavenUtils.class.getSimpleName()));
        MavenUtils utils = new MavenUtils(harvesterClass);
        LOGGER.info(String.format("Successfully initialized %s!", MavenUtils.class.getSimpleName()));
        return utils;
    }

    protected static ETLManager createEtlManager(String moduleName, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier, File cacheFolder) throws InstantiationException, IllegalAccessException {
        LOGGER.info(String.format("Initializing %s...", ETLManager.class.getSimpleName()));
        ETLManager manager = new ETLManager(moduleName, cacheFolder);
        List<AbstractETL<?, ?>> etlComponents = etlSupplier.get();
        for (AbstractETL<?, ?> etl : etlComponents) {
            manager.register(etl);
            LOGGER.info(String.format("Initializing %s...", etl.getName()));
            etl.init(moduleName);
            try {
                etl.update();
            }
            catch (ETLPreconditionException eTLPreconditionException) {
                // empty catch block
            }
            LOGGER.info(String.format("Successfully initialized %s!", etl.getName()));
        }
        manager.loadFromDisk();
        manager.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", ETLManager.class.getSimpleName()));
        return manager;
    }

    protected static Scheduler createScheduler(String moduleName, File cacheFolder) {
        LOGGER.info(String.format("Initializing %s...", Scheduler.class.getSimpleName()));
        File schedulerCachePath = new File(cacheFolder, String.format("cache/%s/schedule.json", moduleName));
        Scheduler sched = new Scheduler(moduleName, schedulerCachePath.toString());
        sched.loadFromDisk();
        sched.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", Scheduler.class.getSimpleName()));
        return sched;
    }

    protected static Configuration createConfiguration(String moduleName, File cacheFolder) {
        LOGGER.info(String.format("Initializing %s...", Configuration.class.getSimpleName()));
        Configuration config = new Configuration(moduleName, new AbstractParameter[0]);
        File configCachePath = new File(cacheFolder, String.format("config/%s/config.json", moduleName));
        config.setCacheFilePath(configCachePath.toString());
        config.loadFromDisk();
        config.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", Configuration.class.getSimpleName()));
        return config;
    }

    private MainContextUtils() {
    }
}

