/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

public class CancelableFuture<T>
extends CompletableFuture<T> {
    private final Future<?> inner;

    public CancelableFuture(Callable<T> task, ExecutorService executor) {
        this.inner = executor.submit(() -> this.complete(task));
    }

    public CancelableFuture(Callable<T> task) {
        ForkJoinPool executor = ForkJoinPool.commonPool();
        this.inner = executor.submit(() -> this.complete(task));
    }

    private void complete(Callable<T> callable) {
        try {
            T result = callable.call();
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterrupt) {
        return this.inner.cancel(mayInterrupt) && super.cancel(true);
    }
}

