/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.utils;

import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.enums.ETLHealth;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.utils.HashGenerator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class EtlUtils {
    public static String getCombinedHashes(Collection<AbstractETL<?, ?>> etls) {
        StringBuffer hashBuilder = new StringBuffer();
        for (AbstractETL<?, ?> etl : etls) {
            if (!etl.isEnabled()) continue;
            String subHash = etl.getHash();
            if (subHash == null) {
                return null;
            }
            hashBuilder.append(subHash);
        }
        if (hashBuilder.length() == 0) {
            return null;
        }
        HashGenerator generator = new HashGenerator(StandardCharsets.UTF_8);
        return generator.getShaHash(hashBuilder.toString());
    }

    public static ETLHealth getCombinedHealth(Collection<AbstractETL<?, ?>> etls) {
        List<ETLHealth> healthStatuses = EtlUtils.processETLsAsList(etls, harvester -> harvester.getHealth());
        ETLHealth overallHealth = ETLHealth.OK;
        if (healthStatuses.contains((Object)ETLHealth.INITIALIZATION_FAILED)) {
            overallHealth = ETLHealth.INITIALIZATION_FAILED;
        } else if (healthStatuses.contains((Object)ETLHealth.HARVEST_FAILED)) {
            overallHealth = ETLHealth.HARVEST_FAILED;
        } else {
            if (healthStatuses.contains((Object)ETLHealth.EXTRACTION_FAILED)) {
                overallHealth = ETLHealth.EXTRACTION_FAILED;
            }
            if (healthStatuses.contains((Object)ETLHealth.TRANSFORMATION_FAILED)) {
                ETLHealth eTLHealth = overallHealth = overallHealth == ETLHealth.OK ? ETLHealth.TRANSFORMATION_FAILED : ETLHealth.HARVEST_FAILED;
            }
            if (healthStatuses.contains((Object)ETLHealth.LOADING_FAILED)) {
                overallHealth = overallHealth == ETLHealth.OK ? ETLHealth.LOADING_FAILED : ETLHealth.HARVEST_FAILED;
            }
        }
        return overallHealth;
    }

    public static long estimateRemainingHarvestTime(long harvestStartTimestamp, ETLState etlStatus, int harvestedDocuments, int maxDocuments) {
        if (etlStatus != ETLState.HARVESTING) {
            return -1L;
        }
        if (maxDocuments == -1) {
            return -1L;
        }
        if (harvestedDocuments == 0) {
            return -1L;
        }
        long millisSinceHarvestStarted = System.currentTimeMillis() - harvestStartTimestamp;
        long averageMillisPerDocument = millisSinceHarvestStarted / (long)harvestedDocuments;
        return averageMillisPerDocument * (long)(maxDocuments - harvestedDocuments);
    }

    public static String formatHarvestTime(long milliseconds) {
        if (milliseconds < 0L || milliseconds == Long.MAX_VALUE) {
            return "Remaining Time : ???";
        }
        long hours = milliseconds / 3600000L;
        return String.format("Remaining Time: %1$02d:%2$tM:%2$tS", hours, milliseconds);
    }

    public static <T> List<T> processETLsAsList(Collection<AbstractETL<?, ?>> etls, Function<AbstractETL<?, ?>, T> function) {
        ArrayList<T> returnValues = new ArrayList<T>(etls.size());
        for (AbstractETL<?, ?> etl : etls) {
            if (!etl.isEnabled()) continue;
            returnValues.add(function.apply(etl));
        }
        return returnValues;
    }

    public static void processETLs(Collection<AbstractETL<?, ?>> etls, Consumer<AbstractETL<?, ?>> consumer) {
        for (AbstractETL<?, ?> etl : etls) {
            if (!etl.isEnabled()) continue;
            consumer.accept(etl);
        }
    }

    public static int sumUpETLValues(Collection<AbstractETL<?, ?>> etls, Function<AbstractETL<?, ?>, Integer> intFunction) {
        List<Integer> processedData = EtlUtils.processETLsAsList(etls, intFunction);
        int total = 0;
        for (int pd : processedData) {
            total += pd;
        }
        return total;
    }

    private EtlUtils() {
    }
}

