/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.json;

import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.events.GetRepositoryNameEvent;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.event.EventSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ETLInfosJson {
    private final ETLJson overallInfo;
    private final Map<String, ETLJson> etlInfos;
    private final String repositoryName;

    public ETLInfosJson(ETLJson overallInfo, List<AbstractETL<?, ?>> registeredEtls) {
        this.overallInfo = overallInfo;
        this.etlInfos = new HashMap<String, ETLJson>();
        for (AbstractETL<?, ?> etl : registeredEtls) {
            this.etlInfos.put(etl.getName(), etl.getAsJson());
        }
        this.repositoryName = (String)EventSystem.sendSynchronousEvent(new GetRepositoryNameEvent());
    }

    public ETLJson getOverallInfo() {
        return this.overallInfo;
    }

    public Map<String, ETLJson> getEtlInfos() {
        return this.etlInfos;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ETLInfosJson)) {
            return false;
        }
        ETLInfosJson other = (ETLInfosJson)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ETLJson this$overallInfo = this.getOverallInfo();
        ETLJson other$overallInfo = other.getOverallInfo();
        if (this$overallInfo == null ? other$overallInfo != null : !((Object)this$overallInfo).equals(other$overallInfo)) {
            return false;
        }
        Map<String, ETLJson> this$etlInfos = this.getEtlInfos();
        Map<String, ETLJson> other$etlInfos = other.getEtlInfos();
        if (this$etlInfos == null ? other$etlInfos != null : !((Object)this$etlInfos).equals(other$etlInfos)) {
            return false;
        }
        String this$repositoryName = this.getRepositoryName();
        String other$repositoryName = other.getRepositoryName();
        return !(this$repositoryName == null ? other$repositoryName != null : !this$repositoryName.equals(other$repositoryName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ETLInfosJson;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ETLJson $overallInfo = this.getOverallInfo();
        result = result * 59 + ($overallInfo == null ? 43 : ((Object)$overallInfo).hashCode());
        Map<String, ETLJson> $etlInfos = this.getEtlInfos();
        result = result * 59 + ($etlInfos == null ? 43 : ((Object)$etlInfos).hashCode());
        String $repositoryName = this.getRepositoryName();
        result = result * 59 + ($repositoryName == null ? 43 : $repositoryName.hashCode());
        return result;
    }

    public String toString() {
        return "ETLInfosJson(overallInfo=" + this.getOverallInfo() + ", etlInfos=" + this.getEtlInfos() + ", repositoryName=" + this.getRepositoryName() + ")";
    }
}

