/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.events;

import de.gerdiproject.harvest.event.IEvent;
import java.time.Instant;

public final class HarvestStartedEvent
implements IEvent {
    private final String harvesterHash;
    private final int maxHarvestableDocuments;
    private final long startTimestamp;

    public HarvestStartedEvent(String harvesterHash, int maxHarvestableDocuments) {
        this(harvesterHash, maxHarvestableDocuments, Instant.now().toEpochMilli());
    }

    public String getHarvesterHash() {
        return this.harvesterHash;
    }

    public int getMaxHarvestableDocuments() {
        return this.maxHarvestableDocuments;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarvestStartedEvent)) {
            return false;
        }
        HarvestStartedEvent other = (HarvestStartedEvent)o;
        String this$harvesterHash = this.getHarvesterHash();
        String other$harvesterHash = other.getHarvesterHash();
        if (this$harvesterHash == null ? other$harvesterHash != null : !this$harvesterHash.equals(other$harvesterHash)) {
            return false;
        }
        if (this.getMaxHarvestableDocuments() != other.getMaxHarvestableDocuments()) {
            return false;
        }
        return this.getStartTimestamp() == other.getStartTimestamp();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $harvesterHash = this.getHarvesterHash();
        result = result * 59 + ($harvesterHash == null ? 43 : $harvesterHash.hashCode());
        result = result * 59 + this.getMaxHarvestableDocuments();
        long $startTimestamp = this.getStartTimestamp();
        result = result * 59 + (int)($startTimestamp >>> 32 ^ $startTimestamp);
        return result;
    }

    public String toString() {
        return "HarvestStartedEvent(harvesterHash=" + this.getHarvesterHash() + ", maxHarvestableDocuments=" + this.getMaxHarvestableDocuments() + ", startTimestamp=" + this.getStartTimestamp() + ")";
    }

    public HarvestStartedEvent(String harvesterHash, int maxHarvestableDocuments, long startTimestamp) {
        this.harvesterHash = harvesterHash;
        this.maxHarvestableDocuments = maxHarvestableDocuments;
        this.startTimestamp = startTimestamp;
    }
}

