/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import de.gerdiproject.harvest.etls.enums.ETLHealth;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.utils.TimestampedList;
import java.lang.reflect.Type;

public class ETLJsonAdapter
implements JsonDeserializer<ETLJson> {
    public ETLJson deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement nameEle = jsonObject.get("name");
        String name = nameEle == null ? null : nameEle.getAsString();
        JsonElement versionHashEle = jsonObject.get("versionHash");
        String versionHash = versionHashEle == null ? null : versionHashEle.getAsString();
        JsonElement harvestedCountEle = jsonObject.get("harvestedCount");
        int harvestedCount = harvestedCountEle == null ? 0 : harvestedCountEle.getAsInt();
        JsonElement maxDocumentCountEle = jsonObject.get("maxDocumentCount");
        int maxDocumentCount = maxDocumentCountEle == null ? 1 : maxDocumentCountEle.getAsInt();
        JsonElement statusHistoryEle = jsonObject.get("statusHistory");
        Type statusHistoryType = new TypeToken<ETLState>(){}.getType();
        TimestampedList statusHistory = (TimestampedList)context.deserialize(statusHistoryEle, statusHistoryType);
        JsonElement healthHistoryEle = jsonObject.get("healthHistory");
        Type healthHistoryType = new TypeToken<ETLHealth>(){}.getType();
        TimestampedList healthHistory = (TimestampedList)context.deserialize(healthHistoryEle, healthHistoryType);
        return new ETLJson(name, statusHistory, healthHistory, harvestedCount, maxDocumentCount, versionHash);
    }
}

