/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls;

import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.events.ParameterChangedEvent;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.constants.ParameterMappingFunctions;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.constants.ETLConstants;
import de.gerdiproject.harvest.etls.enums.ETLHealth;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.loaders.AbstractIteratorLoader;
import de.gerdiproject.harvest.etls.transformers.AbstractIteratorTransformer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIteratorETL<T, S>
extends AbstractETL<Iterator<T>, Iterator<S>> {
    protected volatile IntegerParameter startIndexParameter;
    protected volatile IntegerParameter endIndexParameter;
    protected final AtomicInteger harvestedCount = new AtomicInteger(0);

    public AbstractIteratorETL() {
    }

    public AbstractIteratorETL(String name) {
        super(name);
    }

    @Override
    protected void registerParameters() {
        super.registerParameters();
        this.startIndexParameter = Configuration.registerParameter(new IntegerParameter("rangeFrom", this.getName(), 0, ParameterMappingFunctions.createMapperForETL(ParameterMappingFunctions::mapToUnsignedInteger, this)));
        this.endIndexParameter = Configuration.registerParameter(new IntegerParameter("rangeTo", this.getName(), Integer.MAX_VALUE, ParameterMappingFunctions.createMapperForETL(ParameterMappingFunctions::mapToUnsignedInteger, this)));
    }

    @Override
    public void loadFromJson(ETLJson json) {
        super.loadFromJson(json);
        this.harvestedCount.set(json.getHarvestedCount());
    }

    @Override
    public void prepareHarvest() throws ETLPreconditionException {
        super.prepareHarvest();
        if (this.getStartIndex() == this.getEndIndex()) {
            this.setStatus(ETLState.DONE);
            throw new ETLPreconditionException(String.format("Skipping %s - Document indices out of range.", this.getName()));
        }
        try {
            if (!(this.extractor instanceof AbstractIteratorExtractor)) {
                throw new ETLPreconditionException(ETLConstants.INVALID_ITER_EXTRACTOR_ERROR);
            }
            if (!(this.transformer instanceof AbstractIteratorTransformer)) {
                throw new ETLPreconditionException(ETLConstants.INVALID_ITER_TRANSFORMER_ERROR);
            }
            if (!(this.loader instanceof AbstractIteratorLoader)) {
                throw new ETLPreconditionException(ETLConstants.INVALID_ITER_LOADER_ERROR);
            }
        }
        catch (ETLPreconditionException e) {
            this.setStatus(ETLState.DONE);
            this.setHealth(ETLHealth.HARVEST_FAILED);
            throw e;
        }
        this.harvestedCount.set(0);
    }

    @Override
    public int getHarvestedCount() {
        return this.harvestedCount.get();
    }

    @Override
    public int getMaxNumberOfDocuments() {
        int unrestrictedMaxDocs = super.getMaxNumberOfDocuments();
        if (unrestrictedMaxDocs == -1) {
            return this.getEndIndex() == Integer.MAX_VALUE ? -1 : this.getEndIndex() - this.getStartIndex();
        }
        return Math.min(unrestrictedMaxDocs, this.getEndIndex()) - this.getStartIndex();
    }

    public int getStartIndex() {
        int index = (Integer)this.startIndexParameter.getValue();
        if (index < 0) {
            return 0;
        }
        return index;
    }

    public int getEndIndex() {
        int index = (Integer)this.endIndexParameter.getValue();
        if (index < 0) {
            return 0;
        }
        return index;
    }

    public void incrementHarvestedDocuments() {
        this.harvestedCount.incrementAndGet();
    }

    @Override
    protected void onParameterChanged(ParameterChangedEvent event) {
        super.onParameterChanged(event);
        String paramKey = event.getParameter().getCompositeKey();
        if (this.extractor != null && (paramKey.equals(this.startIndexParameter.getCompositeKey()) || paramKey.equals(this.endIndexParameter.getCompositeKey()))) {
            this.extractor.init(this);
        }
    }
}

