/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.utils.LoaderRegistry;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.utils.logger.HarvesterLog;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MainContextUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainContextUtils.class);

    protected static LoaderRegistry createLoaderRegistry(List<Class<? extends ILoader<?>>> loaderClasses) {
        LOGGER.info(String.format("Initializing %s...", LoaderRegistry.class.getSimpleName()));
        LoaderRegistry registry = new LoaderRegistry();
        registry.addEventListeners();
        for (Class<ILoader<?>> clazz : loaderClasses) {
            registry.registerLoader(clazz);
        }
        LOGGER.info(String.format("Successfully initialized %s!", LoaderRegistry.class.getSimpleName()));
        return registry;
    }

    protected static HarvesterLog createLog(String moduleName) {
        LOGGER.info(String.format("Initializing %s...", HarvesterLog.class.getSimpleName()));
        HarvesterLog serviceLog = new HarvesterLog(String.format("/var/log/harvester/%s.log", moduleName));
        serviceLog.registerLogger();
        LOGGER.info(String.format("Successfully initialized %s!", HarvesterLog.class.getSimpleName()));
        return serviceLog;
    }

    protected static MavenUtils createMavenUtils(Class<?> harvesterClass) {
        LOGGER.info(String.format("Initializing %s...", MavenUtils.class.getSimpleName()));
        MavenUtils utils = new MavenUtils(harvesterClass);
        LOGGER.info(String.format("Successfully initialized %s!", MavenUtils.class.getSimpleName()));
        return utils;
    }

    protected static ETLManager createEtlManager(String moduleName, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier) throws InstantiationException, IllegalAccessException {
        LOGGER.info(String.format("Initializing %s...", ETLManager.class.getSimpleName()));
        ETLManager manager = new ETLManager(moduleName);
        List<AbstractETL<?, ?>> etlComponents = etlSupplier.get();
        for (AbstractETL<?, ?> etl : etlComponents) {
            manager.register(etl);
            LOGGER.info(String.format("Initializing %s...", etl.getName()));
            etl.init(moduleName);
            try {
                etl.update();
            }
            catch (ETLPreconditionException eTLPreconditionException) {
                // empty catch block
            }
            LOGGER.info(String.format("Successfully initialized %s!", etl.getName()));
        }
        manager.loadFromDisk();
        manager.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", ETLManager.class.getSimpleName()));
        return manager;
    }

    protected static Scheduler createScheduler(String moduleName) {
        LOGGER.info(String.format("Initializing %s...", Scheduler.class.getSimpleName()));
        String schedulerCachePath = String.format("cache/%s/schedule.json", moduleName);
        Scheduler sched = new Scheduler(moduleName, schedulerCachePath);
        sched.loadFromDisk();
        sched.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", Scheduler.class.getSimpleName()));
        return sched;
    }

    protected static Configuration createConfiguration(String moduleName) {
        LOGGER.info(String.format("Initializing %s...", Configuration.class.getSimpleName()));
        Configuration config = new Configuration(moduleName, new AbstractParameter[0]);
        config.setCacheFilePath(String.format("config/%s/config.json", moduleName));
        config.loadFromDisk();
        config.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", Configuration.class.getSimpleName()));
        return config;
    }

    private MainContextUtils() {
    }
}

