/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.MainContextUtils;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.events.GetRepositoryNameEvent;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.utils.LoaderRegistry;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.logger.HarvesterLog;
import de.gerdiproject.harvest.utils.logger.events.GetMainLogEvent;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import de.gerdiproject.harvest.utils.maven.events.GetMavenUtilsEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainContext.class);
    private static volatile MainContext instance;
    private static boolean failed;
    private static boolean initialized;
    private final HarvesterLog log;
    private final String moduleName;
    private final ETLManager etlManager;
    private final Configuration configuration;
    private final LoaderRegistry loaderRegistry;
    private final Scheduler scheduler;
    private final MavenUtils mavenUtils;

    private MainContext(Class<? extends ContextListener> callerClass, Supplier<String> repositoryNameSupplier, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier, List<Class<? extends ILoader<?>>> loaderClasses) throws InstantiationException, IllegalAccessException {
        this.moduleName = repositoryNameSupplier.get().replaceAll(" ", "") + "HarvesterService";
        EventSystem.addSynchronousListener(GetRepositoryNameEvent.class, repositoryNameSupplier);
        this.log = MainContextUtils.createLog(this.moduleName);
        EventSystem.addSynchronousListener(GetMainLogEvent.class, this::getLog);
        this.configuration = MainContextUtils.createConfiguration(this.moduleName);
        this.mavenUtils = MainContextUtils.createMavenUtils(callerClass);
        EventSystem.addSynchronousListener(GetMavenUtilsEvent.class, this::getMavenUtils);
        this.loaderRegistry = MainContextUtils.createLoaderRegistry(loaderClasses);
        this.etlManager = MainContextUtils.createEtlManager(this.moduleName, etlSupplier);
        this.scheduler = MainContextUtils.createScheduler(this.moduleName);
    }

    public static void init(Class<? extends ContextListener> callerClass, Supplier<String> repositoryNameSupplier, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier, List<Class<? extends ILoader<?>>> loaderClasses) {
        LOGGER.info("Initializing Harvester Service...");
        failed = false;
        initialized = false;
        CancelableFuture<Boolean> initProcess = new CancelableFuture<Boolean>(() -> {
            MainContext.destroy();
            instance = new MainContext(callerClass, repositoryNameSupplier, etlSupplier, loaderClasses);
            return true;
        });
        ((CompletableFuture)initProcess.thenApply(MainContext::onHarvesterInitializedSuccess)).exceptionally(MainContext::onHarvesterInitializedFailed);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static boolean hasFailed() {
        return failed;
    }

    public static synchronized void destroy() {
        if (instance != null) {
            instance.removeEventListeners();
            MainContext.instance.log.unregisterLogger();
            instance = null;
        }
        failed = false;
        initialized = false;
    }

    private void removeEventListeners() {
        EventSystem.removeSynchronousListener(GetMainLogEvent.class);
        EventSystem.removeSynchronousListener(GetMavenUtilsEvent.class);
        this.scheduler.removeEventListeners();
        this.configuration.removeEventListeners();
        this.etlManager.removeEventListeners();
    }

    private static Boolean onHarvesterInitializedSuccess(Boolean state) {
        failed = false;
        initialized = true;
        EventSystem.sendEvent(new ServiceInitializedEvent(state));
        LOGGER.info(String.format("%s is now ready!", MainContext.instance.moduleName));
        return state;
    }

    private static Boolean onHarvesterInitializedFailed(Throwable reason) {
        failed = true;
        initialized = true;
        LOGGER.error("Initialization of the Harvester Service failed!", reason.getCause());
        EventSystem.sendEvent(new ServiceInitializedEvent(false));
        return false;
    }

    public HarvesterLog getLog() {
        return this.log;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ETLManager getEtlManager() {
        return this.etlManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public LoaderRegistry getLoaderRegistry() {
        return this.loaderRegistry;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public MavenUtils getMavenUtils() {
        return this.mavenUtils;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainContext)) {
            return false;
        }
        MainContext other = (MainContext)o;
        HarvesterLog this$log = this.getLog();
        HarvesterLog other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        String this$moduleName = this.getModuleName();
        String other$moduleName = other.getModuleName();
        if (this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName)) {
            return false;
        }
        ETLManager this$etlManager = this.getEtlManager();
        ETLManager other$etlManager = other.getEtlManager();
        if (this$etlManager == null ? other$etlManager != null : !this$etlManager.equals(other$etlManager)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        LoaderRegistry this$loaderRegistry = this.getLoaderRegistry();
        LoaderRegistry other$loaderRegistry = other.getLoaderRegistry();
        if (this$loaderRegistry == null ? other$loaderRegistry != null : !this$loaderRegistry.equals(other$loaderRegistry)) {
            return false;
        }
        Scheduler this$scheduler = this.getScheduler();
        Scheduler other$scheduler = other.getScheduler();
        if (this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler)) {
            return false;
        }
        MavenUtils this$mavenUtils = this.getMavenUtils();
        MavenUtils other$mavenUtils = other.getMavenUtils();
        return !(this$mavenUtils == null ? other$mavenUtils != null : !this$mavenUtils.equals(other$mavenUtils));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HarvesterLog $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        String $moduleName = this.getModuleName();
        result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
        ETLManager $etlManager = this.getEtlManager();
        result = result * 59 + ($etlManager == null ? 43 : $etlManager.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        LoaderRegistry $loaderRegistry = this.getLoaderRegistry();
        result = result * 59 + ($loaderRegistry == null ? 43 : $loaderRegistry.hashCode());
        Scheduler $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        MavenUtils $mavenUtils = this.getMavenUtils();
        result = result * 59 + ($mavenUtils == null ? 43 : $mavenUtils.hashCode());
        return result;
    }

    public String toString() {
        return "MainContext(log=" + this.getLog() + ", moduleName=" + this.getModuleName() + ", etlManager=" + this.getEtlManager() + ", configuration=" + this.getConfiguration() + ", loaderRegistry=" + this.getLoaderRegistry() + ", scheduler=" + this.getScheduler() + ", mavenUtils=" + this.getMavenUtils() + ")";
    }
}

