/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.application.MainContext;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.application.events.ContextInitializedEvent;
import de.gerdiproject.harvest.application.events.ResetContextEvent;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.loaders.DiskLoader;
import de.gerdiproject.harvest.etls.loaders.ElasticSearchLoader;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.event.EventSystem;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextListener
implements ServletContextListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContextListener.class);

    protected String getServiceName() {
        return this.getRepositoryName() + "HarvesterService";
    }

    protected String getRepositoryName() {
        String className = this.getClass().getSimpleName();
        int suffixIndex = className.lastIndexOf(ContextListener.class.getSimpleName());
        return suffixIndex == -1 ? className : className.substring(0, suffixIndex);
    }

    protected abstract List<? extends AbstractETL<?, ?>> createETLs();

    protected List<Class<? extends ILoader<?>>> getLoaderClasses() {
        LinkedList loaderClasses = new LinkedList();
        loaderClasses.add(ElasticSearchLoader.class);
        loaderClasses.add(DiskLoader.class);
        return loaderClasses;
    }

    public void contextInitialized(ServletContextEvent sce) {
        EventSystem.addListener(ResetContextEvent.class, this::onResetContext);
        MainContext.init(this.getClass(), this::getRepositoryName, this::createETLs, this.getLoaderClasses());
        EventSystem.sendEvent(new ContextInitializedEvent());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        EventSystem.sendEvent(new ContextDestroyedEvent());
        MainContext.destroy();
        String goodbyeMsg = String.format("%s undeployed!", this.getServiceName());
        System.out.println(goodbyeMsg);
    }

    protected void onResetContext(ResetContextEvent event) {
        String resetMsg = String.format("Resetting %s...", this.getServiceName());
        LOGGER.info(resetMsg);
        EventSystem.reset();
        this.contextInitialized(null);
    }
}

