/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.maven;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class MavenUtils {
    private final String harvesterJarName;

    public MavenUtils(Class<?> mainJarClass) {
        URL contextListenerResource = mainJarClass.getResource(mainJarClass.getSimpleName() + ".class");
        if (contextListenerResource == null) {
            contextListenerResource = this.getClass().getResource(mainJarClass.getSimpleName() + ".class");
        }
        this.harvesterJarName = contextListenerResource == null ? null : contextListenerResource.toString().replaceAll("^jar:.+/([^/]*?)\\.jar!.+$|^file:.+/([^/]+)/target/.+$", "$1$2");
    }

    public List<String> getMavenVersionInfo(String groupId) {
        LinkedList<String> dependencyList = new LinkedList<String>();
        String projectFilter = String.format("META-INF/maven/%s", groupId == null ? "" : groupId);
        try {
            Enumeration<URL> gerdiMavenLibraries = Thread.currentThread().getContextClassLoader().getResources(projectFilter);
            while (gerdiMavenLibraries.hasMoreElements()) {
                String resourcePath = gerdiMavenLibraries.nextElement().toString();
                if (!resourcePath.startsWith("jar:")) continue;
                dependencyList.add(resourcePath.replaceAll("^jar:.+/([^/]*?)\\.jar!.+$|^file:.+/([^/]+)/target/.+$", "$1$2"));
            }
        }
        catch (IOException e) {
            return null;
        }
        Collections.sort(dependencyList, String.CASE_INSENSITIVE_ORDER);
        return dependencyList;
    }

    public String getHarvesterJarName() {
        return this.harvesterJarName;
    }
}

