/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.data;

import com.google.gson.Gson;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.data.WebDataRetriever;
import de.gerdiproject.harvest.utils.data.constants.DataOperationConstants;
import de.gerdiproject.harvest.utils.data.enums.RestRequestType;
import de.gerdiproject.json.GsonUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.ws.http.HTTPException;
import org.jsoup.nodes.Document;

public class HttpRequester {
    private final DiskIO diskIO;
    private final WebDataRetriever webDataRetriever;
    private String cacheFolder;
    private final BooleanParameter readFromDisk;
    private final BooleanParameter writeToDisk;

    public HttpRequester() {
        this(GsonUtils.createGeoJsonGsonBuilder().create(), StandardCharsets.UTF_8);
    }

    public HttpRequester(Gson gson, Charset httpCharset) {
        BooleanParameter writeToDiskTemp;
        BooleanParameter readFromDiskTemp;
        try {
            readFromDiskTemp = Configuration.registerParameter(DataOperationConstants.READ_FROM_DISK_PARAM);
            writeToDiskTemp = Configuration.registerParameter(DataOperationConstants.WRITE_TO_DISK_PARAM);
        }
        catch (IllegalStateException e) {
            readFromDiskTemp = DataOperationConstants.READ_FROM_DISK_PARAM;
            writeToDiskTemp = DataOperationConstants.WRITE_TO_DISK_PARAM;
        }
        this.readFromDisk = readFromDiskTemp;
        this.writeToDisk = writeToDiskTemp;
        this.diskIO = new DiskIO(gson, httpCharset);
        this.webDataRetriever = new WebDataRetriever(gson, httpCharset);
        this.setCacheFolder("savedHttpResponses");
    }

    public HttpRequester(HttpRequester other) {
        this.readFromDisk = other.readFromDisk;
        this.writeToDisk = other.writeToDisk;
        this.diskIO = new DiskIO(other.diskIO);
        this.webDataRetriever = new WebDataRetriever(other.webDataRetriever);
        this.setCacheFolder(other.cacheFolder);
    }

    public Document getHtmlFromUrl(String url) {
        Document htmlResponse = null;
        boolean isResponseReadFromWeb = false;
        if (this.isReadingFromDisk()) {
            htmlResponse = this.diskIO.getHtml(this.urlToFilePath(url, "html"));
        }
        if (htmlResponse == null) {
            htmlResponse = this.webDataRetriever.getHtml(url);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.isWritingToDisk()) {
            String responseText = htmlResponse == null ? "" : htmlResponse.toString();
            this.diskIO.writeStringToFile(this.urlToFilePath(url, "html"), responseText);
        }
        return htmlResponse;
    }

    public <T> T getObjectFromUrl(String url, Class<T> targetClass) {
        T targetObject = null;
        boolean isResponseReadFromWeb = false;
        if (this.isReadingFromDisk()) {
            targetObject = this.diskIO.getObject(this.urlToFilePath(url, "json"), targetClass);
        }
        if (targetObject == null) {
            targetObject = this.webDataRetriever.getObject(url, targetClass);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.isWritingToDisk()) {
            this.diskIO.writeObjectToFile(this.urlToFilePath(url, "json"), targetObject);
        }
        return targetObject;
    }

    public <T> T getObjectFromUrl(String url, Type targetType) {
        T targetObject = null;
        boolean isResponseReadFromWeb = false;
        if (this.isReadingFromDisk()) {
            targetObject = this.diskIO.getObject(this.urlToFilePath(url, "json"), targetType);
        }
        if (targetObject == null) {
            targetObject = this.webDataRetriever.getObject(url, targetType);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.isWritingToDisk()) {
            this.diskIO.writeObjectToFile(this.urlToFilePath(url, "json"), targetObject);
        }
        return targetObject;
    }

    private String urlToFilePath(String url, String fileEnding) {
        String path = url;
        int schemeEnd = path.indexOf("://");
        schemeEnd = schemeEnd == -1 ? 0 : schemeEnd + 3;
        path = path.substring(schemeEnd);
        path = path.replace("//", "/");
        path = path.replace(":", "%colon%");
        path = path.replace("?", "%query%/");
        if ((path = path.replace("*", "%star%")).charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        return String.format("%s/%sresponse.%s", this.cacheFolder, path, fileEnding);
    }

    public String getRestResponse(RestRequestType method, String url, String body) throws HTTPException, IOException {
        return this.webDataRetriever.getRestResponse(method, url, body, null, "text/plain");
    }

    public String getRestResponse(RestRequestType method, String url, String body, String authorization, String contentType) throws HTTPException, IOException {
        return this.webDataRetriever.getRestResponse(method, url, body, authorization, contentType);
    }

    public Map<String, List<String>> getRestHeader(RestRequestType method, String url, String body) throws HTTPException, IOException {
        return this.webDataRetriever.getRestHeader(method, url, body, null, "text/plain");
    }

    public Map<String, List<String>> getRestHeader(RestRequestType method, String url, String body, String authorization, String contentType) throws HTTPException, IOException {
        return this.webDataRetriever.getRestHeader(method, url, body, authorization, contentType);
    }

    public String getCacheFolder() {
        return this.cacheFolder;
    }

    public void setCacheFolder(String cacheFolder) {
        this.cacheFolder = cacheFolder == null || cacheFolder.endsWith("/") ? cacheFolder : cacheFolder + '/';
    }

    public void setTimeout(int timeout) {
        this.webDataRetriever.setTimeout(timeout);
    }

    public boolean isReadingFromDisk() {
        return (Boolean)this.readFromDisk.getValue() != false && this.cacheFolder != null;
    }

    public boolean isWritingToDisk() {
        return (Boolean)this.writeToDisk.getValue() != false && this.cacheFolder != null;
    }

    public void setCharset(Charset httpCharset) {
        this.webDataRetriever.setCharset(httpCharset);
        this.diskIO.setCharset(httpCharset);
    }
}

