/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.data;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.utils.data.IDataRetriever;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskIO
implements IDataRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskIO.class);
    private final Gson gson;
    private Charset charset;

    public DiskIO(Gson gson, Charset charset) {
        this.gson = gson;
        this.charset = charset;
    }

    public DiskIO(DiskIO other) {
        this.gson = other.gson;
        this.charset = other.charset;
    }

    public String writeStringToFile(String filePath, String fileContent) {
        return this.writeStringToFile(new File(filePath), fileContent);
    }

    public String writeStringToFile(File file, String fileContent) {
        String statusMessage;
        boolean isDirectoryCreated;
        String filePath = file.getAbsolutePath();
        boolean isSuccessful = false;
        boolean bl = isDirectoryCreated = file.getParentFile().exists() || file.getParentFile().mkdirs();
        if (isDirectoryCreated) {
            try (BufferedWriter writer = FileUtils.getWriter(file, this.charset);){
                writer.write(fileContent);
                isSuccessful = true;
                statusMessage = String.format("Saved file: %s", filePath);
            }
            catch (IOException | SecurityException e) {
                LOGGER.warn(String.format("Could not write to file: %s", filePath), (Throwable)e);
                statusMessage = String.format("Could not write to file: %s", filePath);
            }
        } else {
            statusMessage = String.format("Could not write to file '%s': Failed to create directories!", filePath);
        }
        if (isSuccessful) {
            LOGGER.trace(statusMessage);
        } else {
            LOGGER.warn(statusMessage);
        }
        return statusMessage;
    }

    public String writeObjectToFile(String filePath, Object obj) {
        String jsonString = obj == null ? "{}" : this.gson.toJson(obj);
        return this.writeStringToFile(filePath, jsonString);
    }

    public String writeObjectToFile(File file, Object obj) {
        String jsonString = obj == null ? "{}" : this.gson.toJson(obj);
        return this.writeStringToFile(file, jsonString);
    }

    public String getString(File file) {
        String fileContent = null;
        try (BufferedReader reader2 = FileUtils.getReader(file, this.charset);){
            fileContent = reader2.lines().collect(Collectors.joining("\n"));
        }
        catch (NoSuchFileException reader2) {
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Could not load file: %s", file.getAbsolutePath()), (Throwable)e);
        }
        return fileContent;
    }

    public <T> T getObject(File file, Class<T> targetClass) {
        Object object = null;
        try (BufferedReader reader2 = FileUtils.getReader(file, this.charset);){
            object = this.gson.fromJson((Reader)reader2, targetClass);
        }
        catch (NoSuchFileException reader2) {
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load file: %s", file.getAbsolutePath()), e);
        }
        return (T)object;
    }

    public <T> T getObject(File file, Type targetType) {
        Object object = null;
        try (BufferedReader reader2 = FileUtils.getReader(file, this.charset);){
            object = this.gson.fromJson((Reader)reader2, targetType);
        }
        catch (NoSuchFileException reader2) {
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load file: %s", file.getAbsolutePath()), e);
        }
        return (T)object;
    }

    @Override
    public String getString(String filePath) {
        return this.getString(new File(filePath));
    }

    @Override
    public <T> T getObject(String filePath, Class<T> targetClass) {
        return this.getObject(new File(filePath), targetClass);
    }

    @Override
    public <T> T getObject(String filePath, Type targetType) {
        return this.getObject(new File(filePath), targetType);
    }

    @Override
    public Document getHtml(String filePath) {
        Document htmlResponse = null;
        String fileContent = this.getString(filePath);
        if (fileContent != null) {
            htmlResponse = Jsoup.parse((String)fileContent);
        }
        return htmlResponse;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

