/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.rest;

import com.google.gson.JsonElement;
import de.gerdiproject.harvest.application.MainContext;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import javax.ws.rs.core.Response;

public class HttpResponseFactory {
    public static Response createInitResponse() {
        String message = "Cannot process request: Please wait for the service to be initialized!";
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)HttpResponseFactory.refineEntity(Response.Status.SERVICE_UNAVAILABLE, "Cannot process request: Please wait for the service to be initialized!")).type("text/plain").build();
    }

    public static Response createBusyResponse(String message, long retryInSeconds) {
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)HttpResponseFactory.refineEntity(Response.Status.SERVICE_UNAVAILABLE, message)).type("text/plain");
        if (retryInSeconds > 0L) {
            rb.header("Retry-After", (Object)retryInSeconds);
        }
        return rb.build();
    }

    public static Response createAcceptedResponse(String message) {
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)HttpResponseFactory.refineEntity(Response.Status.ACCEPTED, message)).type("text/plain").build();
    }

    public static Response createFubarResponse() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)HttpResponseFactory.refineEntity(Response.Status.INTERNAL_SERVER_ERROR, "Cannot process request, because the Harvester could not be initialized! Look at the logs for details.")).type("text/plain").build();
    }

    public static Response createUnknownErrorResponse() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)HttpResponseFactory.refineEntity(Response.Status.INTERNAL_SERVER_ERROR, "Cannot process request due to an unknown error!")).type("text/plain").build();
    }

    public static Response createKnownErrorResponse(String message) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)HttpResponseFactory.refineEntity(Response.Status.INTERNAL_SERVER_ERROR, message)).type("text/plain").build();
    }

    public static Response createBadRequestResponse() {
        return HttpResponseFactory.createBadRequestResponse("N/A");
    }

    public static Response createBadRequestResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)HttpResponseFactory.refineEntity(Response.Status.BAD_REQUEST, message)).type("text/plain").build();
    }

    public static Response createMethodNotAllowedResponse() {
        return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)HttpResponseFactory.refineEntity(Response.Status.METHOD_NOT_ALLOWED, "Unsupported HTTP request method!")).type("text/plain").build();
    }

    public static Response createOkResponse(Object entity) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)HttpResponseFactory.refineEntity(Response.Status.OK, entity)).type("application/json").build();
    }

    public static Response createPlainTextOkResponse(String message) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)message.trim()).type("text/plain").build();
    }

    public static Response createValueResponse(Response.Status statusCode, JsonElement value) {
        if (value == null) {
            return HttpResponseFactory.createBadRequestResponse();
        }
        String status = statusCode.getStatusCode() >= 200 && statusCode.getStatusCode() < 400 ? "Ok" : "Failed";
        String valueEntity = String.format("{\"status\":\"%s\",\"value\":%s}", status, value.toString().trim());
        return Response.status((Response.Status)statusCode).entity((Object)valueEntity).type("application/json").build();
    }

    public static Response createServerErrorResponse() {
        if (MainContext.hasFailed()) {
            return HttpResponseFactory.createFubarResponse();
        }
        if (MainContext.isInitialized()) {
            return HttpResponseFactory.createUnknownErrorResponse();
        }
        return HttpResponseFactory.createInitResponse();
    }

    public static Response createSynchronousEventResponse(ISynchronousEvent<?> event) {
        Object eventResponse = EventSystem.sendSynchronousEvent(event);
        if (eventResponse == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        if (eventResponse instanceof Response) {
            return (Response)eventResponse;
        }
        return HttpResponseFactory.createOkResponse(eventResponse);
    }

    private static String refineEntity(Response.Status statusCode, Object entity) {
        String entityString;
        if (entity == null) {
            entityString = "{}";
        } else if (entity instanceof String) {
            String status = statusCode.getStatusCode() >= 200 && statusCode.getStatusCode() < 400 ? "Ok" : "Failed";
            entityString = String.format("{\"status\":\"%s\",\"message\":\"%s\"}", status, ((String)entity).replaceAll("\\n", ";  ").trim());
        } else {
            entityString = entity.toString();
        }
        return entityString;
    }

    private HttpResponseFactory() {
    }
}

