/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.rest;

import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEventListener;
import de.gerdiproject.harvest.rest.events.GetRestObjectEvent;
import java.util.function.Consumer;
import javax.ws.rs.core.MultivaluedMap;

public abstract class AbstractRestObject<T extends AbstractRestObject<T, P>, P>
implements IEventListener {
    protected final String moduleName;
    private final Class<? extends GetRestObjectEvent<T>> getterEventClass;
    private final Consumer<ContextDestroyedEvent> onContextDestroyedCallback;

    public AbstractRestObject(String moduleName, Class<? extends GetRestObjectEvent<T>> getterEventClass) {
        this.moduleName = moduleName;
        this.getterEventClass = getterEventClass;
        this.onContextDestroyedCallback = this::onContextDestroyed;
    }

    @Override
    public void addEventListeners() {
        EventSystem.addSynchronousListener(this.getterEventClass, () -> this);
        EventSystem.addListener(ContextDestroyedEvent.class, this.onContextDestroyedCallback);
    }

    @Override
    public void removeEventListeners() {
        EventSystem.removeSynchronousListener(this.getterEventClass);
        EventSystem.removeListener(ContextDestroyedEvent.class, this.onContextDestroyedCallback);
    }

    public final String getAsPlainText() {
        return String.format("- %s %s -%n%n%s%n%nAllowed Requests:%n", this.moduleName, this.getClass().getSimpleName(), this.getPrettyPlainText());
    }

    protected abstract String getPrettyPlainText();

    public abstract P getAsJson(MultivaluedMap<String, String> var1);

    protected void onContextDestroyed(ContextDestroyedEvent event) {
        this.removeEventListeners();
    }
}

