/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.transformers;

import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.transformers.ITransformer;
import de.gerdiproject.harvest.etls.transformers.TransformerException;
import java.util.Iterator;

public abstract class AbstractIteratorTransformer<T, S>
implements ITransformer<Iterator<T>, Iterator<S>> {
    protected abstract S transformElement(T var1) throws TransformerException;

    @Override
    public Iterator<S> transform(Iterator<T> elements) throws TransformerException {
        return new PassThroughIterator(elements);
    }

    private class PassThroughIterator
    implements Iterator<S> {
        private final Iterator<T> input;

        public PassThroughIterator(Iterator<T> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public S next() {
            Object in;
            try {
                in = this.input.next();
            }
            catch (ExtractorException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ExtractorException(e);
            }
            try {
                return in == null ? null : (Object)AbstractIteratorTransformer.this.transformElement(in);
            }
            catch (TransformerException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new TransformerException(e);
            }
        }
    }
}

