/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import com.google.gson.Gson;
import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.etls.loaders.AbstractURLLoader;
import de.gerdiproject.harvest.etls.loaders.LoaderException;
import de.gerdiproject.harvest.etls.loaders.constants.ElasticSearchConstants;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchError;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchIndex;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchIndexWrapper;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchResponse;
import de.gerdiproject.harvest.utils.data.WebDataRetriever;
import de.gerdiproject.harvest.utils.data.enums.RestRequestType;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.ws.http.HTTPException;

public class ElasticSearchLoader
extends AbstractURLLoader<DataCiteJson> {
    private final Gson gson = GsonUtils.createGerdiDocumentGsonBuilder().create();
    private final WebDataRetriever webRequester = new WebDataRetriever(this.gson, StandardCharsets.UTF_8);

    @Override
    protected void loadBatch(Map<String, IDocument> documents) {
        String response;
        StringBuilder batchRequestBuilder = new StringBuilder();
        for (Map.Entry<String, IDocument> entry : documents.entrySet()) {
            String documentAddInstruction = this.createBulkInstruction(entry.getKey(), entry.getValue());
            batchRequestBuilder.append(documentAddInstruction);
        }
        try {
            response = this.webRequester.getRestResponse(RestRequestType.POST, this.getUrl(), batchRequestBuilder.toString(), this.getCredentials(), "application/json");
        }
        catch (IOException | HTTPException e) {
            throw new LoaderException(e);
        }
        ElasticSearchResponse responseJson = (ElasticSearchResponse)this.gson.fromJson(response, ElasticSearchResponse.class);
        if (responseJson.hasErrors()) {
            this.logger.error(this.getSubmissionErrorText(responseJson));
            Map<String, IDocument> fixedDocuments = this.fixInvalidDocuments(responseJson, documents);
            if (!fixedDocuments.isEmpty()) {
                this.logger.warn("Resubmitting documents after removing invalid fields.");
                this.loadBatch(fixedDocuments);
            }
        }
    }

    private String getSubmissionErrorText(ElasticSearchResponse responseJson) {
        List<ElasticSearchIndexWrapper> loadedItems = responseJson.getItems();
        StringBuilder sb = new StringBuilder();
        int len = loadedItems.size();
        for (int i = 0; i < len; ++i) {
            ElasticSearchIndex indexElement = loadedItems.get(i).getIndex();
            if (indexElement.getError() == null) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(indexElement.getErrorText());
        }
        return sb.toString();
    }

    private String createBulkInstruction(String documentId, IDocument doc) {
        String bulkInstruction;
        if (doc == null) {
            bulkInstruction = String.format("{\"delete\":{\"_id\":\"%s\"}}%n", documentId);
        } else {
            String jsonString = this.charset == StandardCharsets.UTF_8 ? this.toElasticSearchJson(doc) : new String(this.toElasticSearchJson(doc).getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
            bulkInstruction = String.format("{\"index\":{\"_id\":\"%s\"}}%n%s%n", documentId, jsonString);
        }
        return bulkInstruction;
    }

    private String toElasticSearchJson(IDocument document) {
        String jsonString = document.toJson();
        return jsonString.replaceAll("\"value\":\"(\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"]*?Z)?/(\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"]*?Z)?\"", "\"value\":\\{\"gte\":\"$1\",\"lte\":\"$2\"\\}").replaceAll("\"value\":(\"\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"/]*Z\")", "\"value\":\\{\"gte\":$1,\"lte\":$1\\}");
    }

    private Map<String, IDocument> fixInvalidDocuments(ElasticSearchResponse response, Map<String, IDocument> documents) {
        HashMap<String, IDocument> fixedDocMap = new HashMap<String, IDocument>();
        for (ElasticSearchIndexWrapper documentFeedback : response.getItems()) {
            String documentId;
            IDocument doc;
            ElasticSearchError docError = documentFeedback.getIndex().getError();
            if (docError == null || (doc = documents.get(documentId = documentFeedback.getIndex().getId())) == null || !this.tryFixInvalidDocument(doc, docError)) continue;
            fixedDocMap.put(documentId, doc);
        }
        return fixedDocMap;
    }

    private boolean tryFixInvalidDocument(IDocument errorDocument, ElasticSearchError docError) {
        Matcher errorReasonMatcher = ElasticSearchConstants.PARSE_ERROR_REASON_PATTERN.matcher(docError.getReason());
        if (errorReasonMatcher.find()) {
            String invalidFieldName = errorReasonMatcher.group(1);
            try {
                Field invalidField = errorDocument.getClass().getDeclaredField(invalidFieldName);
                boolean accessibility = invalidField.isAccessible();
                invalidField.setAccessible(true);
                invalidField.set(errorDocument, null);
                invalidField.setAccessible(accessibility);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.logger.warn(String.format("Could not remove invalid field '%s' from Document %s!", invalidFieldName, errorDocument.getSourceId()));
            }
        }
        return false;
    }

    @Override
    protected String getUrl() {
        String rawPath;
        if (this.urlParam.getValue() == null) {
            return null;
        }
        try {
            rawPath = new URL((String)this.urlParam.getValue()).getPath() + '/';
        }
        catch (MalformedURLException e) {
            this.logger.error(String.format("Invalid Elasticsearch API URL: %s", this.urlParam.getValue()));
            return null;
        }
        String[] path = rawPath.substring(1).split("/");
        String rawUrl = this.urlParam.getStringValue();
        if (path.length == 0 || !path[path.length - 1].equals("_bulk")) {
            char lastChar;
            StringBuilder bulkSubmitUrlBuilder = new StringBuilder();
            int queryIndex = rawUrl.indexOf(63);
            if (queryIndex == -1) {
                bulkSubmitUrlBuilder.append(rawUrl);
                lastChar = rawUrl.charAt(rawUrl.length() - 1);
            } else {
                bulkSubmitUrlBuilder.append(rawUrl.substring(0, queryIndex));
                lastChar = rawUrl.charAt(queryIndex - 1);
            }
            if (lastChar != '/') {
                bulkSubmitUrlBuilder.append('/');
            }
            bulkSubmitUrlBuilder.append("_bulk");
            return bulkSubmitUrlBuilder.toString();
        }
        return rawUrl;
    }

    @Override
    protected String getCredentials() {
        String credentials = super.getCredentials();
        if (credentials != null) {
            return "Basic " + credentials;
        }
        return null;
    }

    @Override
    protected int getSizeOfDocument(String documentId, IDocument document) {
        return this.createBulkInstruction(documentId, document).getBytes(StandardCharsets.UTF_8).length;
    }
}

