/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.loaders.AbstractIteratorLoader;
import de.gerdiproject.harvest.etls.loaders.LoaderException;
import de.gerdiproject.harvest.etls.loaders.constants.DiskLoaderConstants;
import de.gerdiproject.harvest.etls.transformers.TransformerException;
import de.gerdiproject.harvest.utils.file.FileUtils;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class DiskLoader
extends AbstractIteratorLoader<DataCiteJson> {
    private final Gson gson;
    private final StringParameter saveFolderParam = Configuration.registerParameter(DiskLoaderConstants.FILE_PATH_PARAM);
    private JsonWriter writer;
    private File targetFile;

    public DiskLoader() {
        this.gson = GsonUtils.createGerdiDocumentGsonBuilder().create();
    }

    @Override
    public void unregisterParameters() {
        Configuration.unregisterParameter(this.saveFolderParam);
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    @Override
    public void load(Iterator<DataCiteJson> documents) throws LoaderException {
        try {
            super.load(documents);
        }
        catch (ExtractorException | LoaderException | TransformerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new LoaderException(e);
        }
    }

    @Override
    public void init(AbstractETL<?, ?> etl) {
        super.init(etl);
        String fileName = etl.getName() + ".json";
        this.targetFile = new File(this.saveFolderParam.getStringValue(), fileName);
        FileUtils.createEmptyFile(this.targetFile);
        if (!this.targetFile.exists() || this.targetFile.length() != 0L) {
            throw new IllegalStateException(String.format("Could not save harvest to disk: Could not create file '%s' on the server!", this.targetFile));
        }
        try {
            this.writer = new JsonWriter((Writer)FileUtils.getWriter(this.targetFile, etl.getCharset()));
            this.writer.beginObject();
            this.writer.name("harvestDate");
            this.writer.value(System.currentTimeMillis());
            String sourceHash = etl.getHash();
            if (sourceHash != null) {
                this.writer.name("sourceHash");
                this.writer.value(sourceHash);
            }
            this.writer.name("documents");
            this.writer.beginArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clear() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.endArray();
            this.writer.endObject();
            this.writer.close();
            this.writer = null;
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
        if (!this.hasLoadedDocuments) {
            FileUtils.deleteFile(this.getTargetFile());
        }
    }

    @Override
    public void loadElement(DataCiteJson document) throws LoaderException {
        if (document != null) {
            try {
                this.gson.toJson((Object)document, document.getClass(), this.writer);
            }
            catch (JsonIOException e) {
                throw new LoaderException(e);
            }
        }
    }
}

