/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.extractors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.harvest.utils.data.HttpRequester;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;

public class JsonArrayExtractor<T>
extends AbstractIteratorExtractor<T> {
    private final Type listType = new TypeToken<List<T>>(){}.getType();
    private final Gson gson;
    private final String jsonQuery;
    private final HttpRequester httpRequester;
    private String url;
    private String hash;
    private List<T> extractedList;

    public JsonArrayExtractor(Gson gson, String jsonQuery) {
        this.jsonQuery = jsonQuery;
        this.httpRequester = new HttpRequester(gson, StandardCharsets.UTF_8);
        this.gson = gson;
    }

    public JsonArrayExtractor(Gson gson) {
        this(gson, null);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void init(AbstractETL<?, ?> etl) {
        super.init(etl);
        JsonElement jsonResponse = this.httpRequester.getObjectFromUrl(this.url, JsonElement.class);
        this.extractedList = this.getListFromJson(jsonResponse);
        this.hash = this.getHashFromJson(jsonResponse);
    }

    @Override
    public Iterator<T> extractAll() {
        return this.extractedList.listIterator();
    }

    @Override
    public int size() {
        return this.extractedList.size();
    }

    @Override
    public String getUniqueVersionString() {
        return this.hash;
    }

    protected String getHashFromJson(JsonElement json) {
        HashGenerator gen = new HashGenerator(StandardCharsets.UTF_8);
        return gen.getShaHash(json.toString());
    }

    protected List<T> getListFromJson(JsonElement inputJson) throws ExtractorException {
        JsonElement json = inputJson;
        if (this.jsonQuery != null) {
            String[] splitJsonQuery;
            for (String q : splitJsonQuery = this.jsonQuery.split("\\.")) {
                json = json.getAsJsonObject().get(q);
            }
        }
        try {
            return (List)this.gson.fromJson(json, this.listType);
        }
        catch (JsonSyntaxException e) {
            throw new ExtractorException(e);
        }
    }

    @Override
    public void clear() {
    }
}

