/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.extractors;

import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.AbstractIteratorETL;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.extractors.IExtractor;
import java.util.Iterator;

public abstract class AbstractIteratorExtractor<T>
implements IExtractor<Iterator<T>> {
    protected int startIndex;
    protected int endIndex;

    @Override
    public void init(AbstractETL<?, ?> etl) {
        if (etl instanceof AbstractIteratorETL) {
            AbstractIteratorETL iterHarvester = (AbstractIteratorETL)etl;
            this.startIndex = iterHarvester.getStartIndex();
            this.endIndex = iterHarvester.getEndIndex();
        }
    }

    protected abstract Iterator<T> extractAll() throws ExtractorException;

    @Override
    public Iterator<T> extract() throws ExtractorException {
        if (this.endIndex == Integer.MAX_VALUE && this.startIndex == 0) {
            return this.extractAll();
        }
        return new RangeRestrictedIterator(this.extractAll());
    }

    @Override
    public int size() {
        if (this.endIndex == Integer.MAX_VALUE) {
            return -1;
        }
        return this.endIndex - this.startIndex;
    }

    private class RangeRestrictedIterator
    implements Iterator<T> {
        private final Iterator<T> completeIterator;
        private int index;

        public RangeRestrictedIterator(Iterator<T> completeIterator) {
            this.completeIterator = completeIterator;
            this.index = 0;
            while (this.index < AbstractIteratorExtractor.this.startIndex && completeIterator.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return (this.index < AbstractIteratorExtractor.this.endIndex || AbstractIteratorExtractor.this.endIndex == Integer.MAX_VALUE) && this.completeIterator.hasNext();
        }

        @Override
        public T next() {
            ++this.index;
            try {
                return this.completeIterator.next();
            }
            catch (RuntimeException e) {
                throw new ExtractorException(e);
            }
        }
    }
}

