/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.events;

import de.gerdiproject.harvest.event.IEvent;
import java.time.Instant;

public class HarvestStartedEvent
implements IEvent {
    private final int maxHarvestableDocuments;
    private final long startTimestamp;
    private final String harvesterHash;

    public HarvestStartedEvent(String harvesterHash, int maxHarvestableDocuments) {
        this(harvesterHash, maxHarvestableDocuments, Instant.now().toEpochMilli());
    }

    public HarvestStartedEvent(String harvesterHash, int maxHarvestableDocuments, long timestamp) {
        this.harvesterHash = harvesterHash;
        this.maxHarvestableDocuments = maxHarvestableDocuments;
        this.startTimestamp = timestamp;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public String getHarvesterHash() {
        return this.harvesterHash;
    }

    public int getMaxHarvestableDocuments() {
        return this.maxHarvestableDocuments;
    }
}

