/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.gerdiproject.AbstractFileSystemUnitTest;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.utils.data.HttpRequester;
import de.gerdiproject.harvest.utils.data.constants.DataOperationConstants;
import de.gerdiproject.harvest.utils.data.enums.RestRequestType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.ws.http.HTTPException;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpRequesterTest
extends AbstractFileSystemUnitTest<HttpRequester> {
    private static final String MOCKED_RESPONSE_CACHE_FOLDER = "src/test/java/de/gerdiproject/utils/examples/httprequester/";
    private static final String JSON_OBJECT_URL = "http://fenixservices.fao.org/faostat/api/v1/en/documents/RFB/";
    private static final String DEFAULT_URL = "https://www.gerdi-project.eu/";
    private static final String UNEXPECTED_FILE_ERROR = "This file should not exist: ";
    private static final String CACHED_JSON = "response.json";
    private static final String CACHED_HTML = "response.html";
    private static final String MOCKED_RESPONSE_FOLDER = "mocked";
    private static final String READ_FROM_DISK_KEY = DataOperationConstants.READ_FROM_DISK_PARAM.getCompositeKey();
    private static final String WRITE_TO_DISK_KEY = DataOperationConstants.WRITE_TO_DISK_PARAM.getCompositeKey();
    private boolean isCachingEnabled;
    private String messageNotCached;

    @Parameterized.Parameters(name="caching enabled: {0}")
    public static Object[] getParameters() {
        return new Object[]{Boolean.FALSE, Boolean.TRUE};
    }

    public HttpRequesterTest(boolean isCachingEnabled) {
        this.isCachingEnabled = isCachingEnabled;
        this.messageNotCached = isCachingEnabled ? "" : "NOT";
    }

    protected HttpRequester setUpTestObjects() {
        this.config = new Configuration("UnitTestModule", new AbstractParameter[0]);
        this.config.addEventListeners();
        HttpRequester requester = new HttpRequester(new Gson(), StandardCharsets.UTF_8);
        requester.setCacheFolder(this.testFolder.getPath());
        this.config.setParameter(READ_FROM_DISK_KEY, String.valueOf(this.isCachingEnabled));
        this.config.setParameter(WRITE_TO_DISK_KEY, String.valueOf(this.isCachingEnabled));
        return requester;
    }

    @Test
    public void testReadFromDiskFlag() {
        Assert.assertEquals((String)("The method isReadingFromDisk() should return " + this.isCachingEnabled + " when the " + READ_FROM_DISK_KEY + "-parameter is set to " + this.isCachingEnabled), (Object)this.isCachingEnabled, (Object)((HttpRequester)this.testedObject).isReadingFromDisk());
    }

    @Test
    public void testWriteToDiskFlag() {
        Assert.assertEquals((String)("The method isWritingToDisk() should return " + this.isCachingEnabled + " when the " + WRITE_TO_DISK_KEY + "-parameter is set to " + this.isCachingEnabled), (Object)this.isCachingEnabled, (Object)((HttpRequester)this.testedObject).isWritingToDisk());
    }

    @Test
    public void testCacheFolder() {
        Assert.assertNotNull((String)"The method getCacheFolder() should not return null!", (Object)((HttpRequester)this.testedObject).getCacheFolder());
    }

    @Test
    public void testGettingHtml() {
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        String requestUrl = this.isCachingEnabled ? "https://www.gerdi-project.eu/mocked" : DEFAULT_URL;
        Document htmlObject = ((HttpRequester)this.testedObject).getHtmlFromUrl(requestUrl);
        Assert.assertNotNull((String)("The method getHtmlFromUrl(\"" + requestUrl + "\") should not return null!"), (Object)htmlObject);
    }

    @Test
    public void testGettingHtmlFromInvalidUrl() {
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        this.setLoggerEnabled(false);
        String requestUrl = "https://www.gerdi-project.eu//thisDoesNotExist";
        Document htmlObject = ((HttpRequester)this.testedObject).getHtmlFromUrl("https://www.gerdi-project.eu//thisDoesNotExist");
        this.setLoggerEnabled(true);
        Assert.assertNull((String)"The method getHtmlFromUrl() called with the non-existing URL \"https://www.gerdi-project.eu//thisDoesNotExist\" should return null!", (Object)htmlObject);
    }

    @Test
    public void testGettingUncachedHtml() throws IOException {
        this.skipTestIfCachingDisabled();
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        File cachedResponse = new File(((HttpRequester)this.testedObject).getCacheFolder() + DEFAULT_URL.substring(7) + CACHED_HTML);
        if (cachedResponse.exists()) {
            throw new IOException(UNEXPECTED_FILE_ERROR + cachedResponse.getAbsolutePath());
        }
        Document htmlObject = ((HttpRequester)this.testedObject).getHtmlFromUrl(DEFAULT_URL);
        Assert.assertNotNull((String)"The method getHtmlFromUrl(\"https://www.gerdi-project.eu/\") should retrieve a response from the web, if the response was not cached!", (Object)htmlObject);
    }

    @Test
    public void testCachingHtml() {
        File cachedResponse = new File(((HttpRequester)this.testedObject).getCacheFolder() + DEFAULT_URL.substring(7) + CACHED_HTML);
        ((HttpRequester)this.testedObject).getHtmlFromUrl(DEFAULT_URL);
        Assert.assertEquals((String)("The method getHtmlFromUrl() should " + this.messageNotCached + " cache the response on disk if the " + WRITE_TO_DISK_KEY + "-parameter is " + this.isCachingEnabled), (Object)this.isCachingEnabled, (Object)cachedResponse.exists());
    }

    @Test
    public void testGettingObject() {
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        String requestUrl = this.isCachingEnabled ? "http://fenixservices.fao.org/faostat/api/v1/en/documents/RFB/mocked" : JSON_OBJECT_URL;
        JsonObject obj = (JsonObject)((HttpRequester)this.testedObject).getObjectFromUrl(requestUrl, JsonObject.class);
        Assert.assertNotNull((String)("The method getObjectFromUrl(\"" + requestUrl + "\") should not return null!"), (Object)obj);
    }

    @Test
    public void testGettingUncachedObject() throws IOException {
        this.skipTestIfCachingDisabled();
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        File cachedResponse = new File(((HttpRequester)this.testedObject).getCacheFolder() + JSON_OBJECT_URL.substring(7) + CACHED_JSON);
        if (cachedResponse.exists()) {
            throw new IOException(UNEXPECTED_FILE_ERROR + cachedResponse.getAbsolutePath());
        }
        JsonObject obj = (JsonObject)((HttpRequester)this.testedObject).getObjectFromUrl(JSON_OBJECT_URL, JsonObject.class);
        Assert.assertNotNull((String)"The method getObjectFromUrl(\"https://www.gerdi-project.eu/\") should retrieve a response from the web, if the response was not cached!", (Object)obj);
    }

    @Test
    public void testCachingObject() throws IOException {
        File cachedResponse = new File(this.testFolder, JSON_OBJECT_URL.substring(7) + CACHED_JSON);
        ((HttpRequester)this.testedObject).getObjectFromUrl(JSON_OBJECT_URL, JsonObject.class);
        Assert.assertEquals((String)("The method getObjectFromUrl() should " + this.messageNotCached + " cache the response on disk if the " + WRITE_TO_DISK_KEY + "-parameter is " + this.isCachingEnabled), (Object)this.isCachingEnabled, (Object)cachedResponse.exists());
    }

    @Test
    public void testGetRequestResponse() throws IOException, HTTPException {
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        String response = ((HttpRequester)this.testedObject).getRestResponse(RestRequestType.GET, DEFAULT_URL, null, null, "text/html");
        Assert.assertNotNull((String)"Sending a GET request to \"https://www.gerdi-project.eu/\" should return a response!", (Object)response);
    }

    @Test
    public void testGettingHeader() throws IOException, HTTPException {
        this.testedObject = this.createReadOnlyExampleHttpRequester();
        Map header = ((HttpRequester)this.testedObject).getRestHeader(RestRequestType.GET, DEFAULT_URL, null);
        Assert.assertFalse((String)"The map returned by getRestHeader(\"https://www.gerdi-project.eu/\", null) should not be empty!", (boolean)header.isEmpty());
    }

    private HttpRequester createReadOnlyExampleHttpRequester() {
        this.config.setParameter(DataOperationConstants.READ_FROM_DISK_PARAM.getCompositeKey(), String.valueOf(this.isCachingEnabled));
        this.config.setParameter(DataOperationConstants.WRITE_TO_DISK_PARAM.getCompositeKey(), String.valueOf(false));
        HttpRequester requester = new HttpRequester(new Gson(), StandardCharsets.UTF_8);
        requester.setCacheFolder(MOCKED_RESPONSE_CACHE_FOLDER);
        return requester;
    }

    private void skipTestIfCachingDisabled() {
        Assume.assumeTrue((String)"Skipping test, because it only makes sense when caching is enabled.", (boolean)this.isCachingEnabled);
    }
}

