/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.utils;

import com.google.gson.Gson;
import de.gerdiproject.AbstractUnitTest;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest
extends AbstractUnitTest {
    private static final File TEST_FOLDER = new File("mocked");
    private static final File FILE_TEST_FOLDER = new File("mocked/fileUtilsTestDir");
    private static final File TEST_MULTI_DIRECTORY = new File(FILE_TEST_FOLDER, "moarTests/moar");
    private static final File TEST_FILE = new File(FILE_TEST_FOLDER, "fileUtilsTest.file");
    private static final File COPY_TEST_SOURCE_DIR = new File(FILE_TEST_FOLDER, "copyTestFrom/aaa/");
    private static final File COPY_TEST_TARGET_DIR = new File(FILE_TEST_FOLDER, "copyTestTo/bbb/");
    private static final File COPY_TEST_SOURCE_FILE = new File(COPY_TEST_SOURCE_DIR, "fileUtilsCopyTestSource.file");
    private static final File COPY_TEST_TARGET_FILE = new File(COPY_TEST_TARGET_DIR, "fileUtilsCopyTestTarget.file");
    private static final String COPY_TEST_TEXT = "Milch macht m\u00fcde M\u00e4nner munter.";
    private static final String COPY_TEST_OVERWRITE_TEXT = "Ohne Krimi geht die Mimi nie ins Bett.";
    private static final File MERGE_TEST_SOURCE_DIR = new File(FILE_TEST_FOLDER, "mergeTestFrom");
    private static final File MERGE_TEST_TARGET_DIR = new File(FILE_TEST_FOLDER, "mergeTestTo");
    private static final List<File> MERGE_TEST_SOURCE_FILES = Collections.unmodifiableList(Arrays.asList(new File(FILE_TEST_FOLDER, "mergeTestFrom/aaa/first.file"), new File(FILE_TEST_FOLDER, "mergeTestFrom/ccc/fifth.file"), new File(FILE_TEST_FOLDER, "mergeTestFrom/ccc/sixth.file")));
    private static final List<File> MERGE_TEST_MERGED_SOURCE_FILES = Collections.unmodifiableList(Arrays.asList(new File(FILE_TEST_FOLDER, "mergeTestTo/aaa/first.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/ccc/fifth.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/ccc/sixth.file")));
    private static final List<File> MERGE_TEST_TARGET_FILES = Collections.unmodifiableList(Arrays.asList(new File(FILE_TEST_FOLDER, "mergeTestTo/aaa/first.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/aaa/second.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/bbb/third.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/bbb/fourth.file")));
    private static final List<File> MERGE_TEST_EXPECTED_TARGET_FILES = Collections.unmodifiableList(Arrays.asList(new File(FILE_TEST_FOLDER, "mergeTestTo/aaa/first.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/aaa/second.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/bbb/third.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/bbb/fourth.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/ccc/fifth.file"), new File(FILE_TEST_FOLDER, "mergeTestTo/ccc/sixth.file")));
    private static final String DUPLICATE_DIR_ERROR = "Creating directories that already exist, should not cause exceptions";
    private static final String DELETE_DIR_ERROR = "Deleting non-existing directories, should not cause exceptions";
    private static final String DELETE_FILE_ERROR = "Deleting non-existing files, should not cause exceptions";

    public void before() throws InstantiationException {
        super.before();
        FileUtils.deleteFile((File)TEST_FOLDER);
        if (TEST_FOLDER.exists()) {
            throw new InstantiationException();
        }
    }

    public void after() {
        super.after();
        FileUtils.deleteFile((File)TEST_FOLDER);
    }

    @Test
    public void testFileCreation() {
        FileUtils.createEmptyFile((File)TEST_FILE);
        Assert.assertTrue((String)"The method createEmptyFile() should create an empty file, duh!", (TEST_FILE.exists() && TEST_FILE.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testFileCreationExisting() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(TEST_FILE, COPY_TEST_TEXT);
        FileUtils.createEmptyFile((File)TEST_FILE);
        Assert.assertEquals((String)"The method createEmptyFile() should overwrite existing files!", (long)0L, (long)TEST_FILE.length());
    }

    @Test
    public void testFileDeletion() {
        FileUtils.createEmptyFile((File)TEST_FILE);
        FileUtils.deleteFile((File)TEST_FILE);
        Assert.assertFalse((String)"The method deleteFile() should remove files from the file system!", (boolean)TEST_FILE.exists());
    }

    @Test
    public void testFileDeletionNonExisting() {
        try {
            FileUtils.deleteFile((File)TEST_FILE);
        }
        catch (Exception e) {
            Assert.fail((String)DELETE_FILE_ERROR);
        }
    }

    @Test
    public void testFileCopyingWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        FileUtils.copyFile((File)COPY_TEST_SOURCE_FILE, (File)COPY_TEST_TARGET_FILE);
        Assert.assertEquals((String)"The method copyFile() should create new files if the target destination does not exist!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(COPY_TEST_TARGET_FILE));
    }

    @Test
    public void testFileCopyingWithoutSource() {
        FileUtils.copyFile((File)COPY_TEST_SOURCE_FILE, (File)COPY_TEST_TARGET_FILE);
        Assert.assertFalse((String)"The method copyFile() should not create files if the source file does not exist!", (boolean)COPY_TEST_TARGET_FILE.exists());
    }

    @Test
    public void testFileCopyingWithTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(COPY_TEST_TARGET_FILE, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.copyFile((File)COPY_TEST_SOURCE_FILE, (File)COPY_TEST_TARGET_FILE);
        Assert.assertEquals((String)"The method copyFile() should overwrite existing target files!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(COPY_TEST_TARGET_FILE));
    }

    @Test
    public void testIfFileReplacementRemovesSourceFile() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(COPY_TEST_TARGET_FILE, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.replaceFile((File)COPY_TEST_TARGET_FILE, (File)COPY_TEST_SOURCE_FILE);
        Assert.assertFalse((String)"The method replaceFile() should remove the source file!", (boolean)COPY_TEST_SOURCE_FILE.exists());
    }

    @Test
    public void testFileReplacementReplacesTargetFile() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(COPY_TEST_TARGET_FILE, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.replaceFile((File)COPY_TEST_TARGET_FILE, (File)COPY_TEST_SOURCE_FILE);
        Assert.assertEquals((String)"The method replaceFile() should overwrite existing target files!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(COPY_TEST_TARGET_FILE));
    }

    @Test
    public void testFileReplacementRemovesBackupFile() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(COPY_TEST_TARGET_FILE, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.replaceFile((File)COPY_TEST_TARGET_FILE, (File)COPY_TEST_SOURCE_FILE);
        Assert.assertFalse((String)"The method replaceFile() should remove the backup files created during execution of the method!", (boolean)new File(COPY_TEST_TARGET_FILE.getPath() + ".tmp").exists());
    }

    @Test
    public void testFileReplacementWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        FileUtils.replaceFile((File)COPY_TEST_TARGET_FILE, (File)COPY_TEST_SOURCE_FILE);
        Assert.assertEquals((String)"The method replaceFile() should create target files if they are missing!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(COPY_TEST_TARGET_FILE));
    }

    @Test
    public void testFileReplacementWithoutSource() {
        FileUtils.replaceFile((File)COPY_TEST_TARGET_FILE, (File)COPY_TEST_SOURCE_FILE);
        Assert.assertFalse((String)"The method replaceFile() should not alter the file system if the source file is missing!", (boolean)COPY_TEST_TARGET_FILE.exists());
    }

    @Test
    public void testDirectoryCreation() {
        FileUtils.createDirectories((File)TEST_MULTI_DIRECTORY);
        Assert.assertTrue((String)"The method createDirectories() should create directories!", (TEST_MULTI_DIRECTORY.exists() && TEST_MULTI_DIRECTORY.isDirectory() ? 1 : 0) != 0);
    }

    @Test
    public void testDirectoryCreationExisting() {
        FileUtils.createDirectories((File)TEST_MULTI_DIRECTORY);
        try {
            FileUtils.createDirectories((File)TEST_MULTI_DIRECTORY);
        }
        catch (Exception e) {
            Assert.fail((String)DUPLICATE_DIR_ERROR);
        }
    }

    @Test
    public void testDirectoryDeletion() {
        FileUtils.createDirectories((File)TEST_MULTI_DIRECTORY);
        FileUtils.deleteFile((File)FILE_TEST_FOLDER);
        Assert.assertFalse((String)"The method deleteFile() should create directories!", (boolean)FILE_TEST_FOLDER.exists());
    }

    @Test
    public void testDirectoryDeletionNonExisting() {
        try {
            FileUtils.deleteFile((File)FILE_TEST_FOLDER);
        }
        catch (Exception e) {
            Assert.fail((String)DELETE_DIR_ERROR);
        }
    }

    @Test
    public void testDirectoryCopyingWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        FileUtils.copyFile((File)COPY_TEST_SOURCE_DIR, (File)COPY_TEST_TARGET_DIR);
        File targetFile = new File(COPY_TEST_TARGET_DIR, COPY_TEST_SOURCE_FILE.getName());
        Assert.assertEquals((String)"The method copyFile() should create target directories if they are missing!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryCopyingWithoutSource() {
        FileUtils.copyFile((File)COPY_TEST_SOURCE_DIR, (File)COPY_TEST_TARGET_DIR);
        Assert.assertFalse((String)"The method copyFile() should not create directories if there are no source directories!", (boolean)COPY_TEST_TARGET_DIR.exists());
    }

    @Test
    public void testDirectoryCopyingWithTarget() {
        File targetFile = new File(COPY_TEST_TARGET_DIR, COPY_TEST_SOURCE_FILE.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(targetFile, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.copyFile((File)COPY_TEST_SOURCE_DIR, (File)COPY_TEST_TARGET_DIR);
        Assert.assertEquals((String)"The method copyFile(), if applied to directories, should overwrite existing directories!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryReplacementFileOverwrite() {
        File targetFile = new File(COPY_TEST_TARGET_FILE.getParentFile(), COPY_TEST_SOURCE_FILE.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(targetFile, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.replaceFile((File)targetFile.getParentFile(), (File)COPY_TEST_SOURCE_FILE.getParentFile());
        Assert.assertEquals((String)"The method replaceFile() should overwrite existing files in a targeted directory!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryReplacementSourceDeletion() {
        File targetFile = new File(COPY_TEST_TARGET_FILE.getParentFile(), COPY_TEST_SOURCE_FILE.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(targetFile, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.replaceFile((File)targetFile.getParentFile(), (File)COPY_TEST_SOURCE_FILE.getParentFile());
        Assert.assertFalse((String)"The method replaceFile(), when applied to a directory, should delete the source directory!", (boolean)COPY_TEST_SOURCE_FILE.getParentFile().exists());
    }

    @Test
    public void testDirectoryReplacementCleanUp() {
        File targetFile = new File(COPY_TEST_TARGET_FILE.getParentFile(), COPY_TEST_SOURCE_FILE.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        diskIo.writeStringToFile(targetFile, COPY_TEST_OVERWRITE_TEXT);
        FileUtils.replaceFile((File)targetFile.getParentFile(), (File)COPY_TEST_SOURCE_FILE.getParentFile());
        Assert.assertFalse((String)"The method replaceFile() should clean up all backup files created in the process!", (boolean)new File(targetFile.getPath() + ".tmp").exists());
    }

    @Test
    public void testDirectoryReplacementWithoutTarget() {
        File targetFile = new File(COPY_TEST_TARGET_DIR, COPY_TEST_SOURCE_FILE.getName());
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        diskIo.writeStringToFile(COPY_TEST_SOURCE_FILE, COPY_TEST_TEXT);
        FileUtils.replaceFile((File)COPY_TEST_TARGET_DIR, (File)COPY_TEST_SOURCE_DIR);
        Assert.assertEquals((String)"The method replaceFile() should create a target directory if it is missing!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(targetFile));
    }

    @Test
    public void testDirectoryReplacementWithoutSource() {
        FileUtils.replaceFile((File)COPY_TEST_TARGET_DIR, (File)COPY_TEST_SOURCE_DIR);
        Assert.assertFalse((String)"The method replaceFile() should not create directories if the source directory is missing!", (boolean)COPY_TEST_TARGET_DIR.exists());
    }

    @Test
    public void testReplacingDirectoryMergeWithTarget() {
        this.assertDirectoryIntegration(true);
    }

    @Test
    public void testNonReplacingDirectoryMergeWithTarget() {
        this.assertDirectoryIntegration(false);
    }

    @Test
    public void testDirectoryMergeWithoutTarget() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : MERGE_TEST_SOURCE_FILES) {
            diskIo.writeStringToFile(sourceFile, COPY_TEST_TEXT);
        }
        FileUtils.integrateDirectory((File)MERGE_TEST_SOURCE_DIR, (File)MERGE_TEST_TARGET_DIR, (boolean)false);
        for (File targetFile : MERGE_TEST_MERGED_SOURCE_FILES) {
            Assert.assertEquals((String)"The method integrateDirectory() should create target directories if they are missing!", (Object)COPY_TEST_TEXT, (Object)diskIo.getString(targetFile));
        }
    }

    @Test
    public void testDirectoryMergeWithoutTargetRemovingOldDirectory() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : MERGE_TEST_SOURCE_FILES) {
            diskIo.writeStringToFile(sourceFile, COPY_TEST_TEXT);
        }
        FileUtils.integrateDirectory((File)MERGE_TEST_SOURCE_DIR, (File)MERGE_TEST_TARGET_DIR, (boolean)false);
        for (File sourceFile : MERGE_TEST_SOURCE_FILES) {
            Assert.assertFalse((String)"The method integrateDirectory() should remove all source files!", (boolean)sourceFile.exists());
        }
    }

    @Test
    public void testDirectoryMergeWithoutSource() {
        FileUtils.integrateDirectory((File)MERGE_TEST_SOURCE_DIR, (File)MERGE_TEST_TARGET_DIR, (boolean)false);
        Assert.assertFalse((String)"The method integrateDirectory() should not create directories if the source does not exist!", (boolean)MERGE_TEST_TARGET_DIR.exists());
    }

    @Test
    public void testDirectoryMergeCompletion() {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : MERGE_TEST_SOURCE_FILES) {
            diskIo.writeStringToFile(sourceFile, COPY_TEST_TEXT);
        }
        for (File targetFile : MERGE_TEST_TARGET_FILES) {
            diskIo.writeStringToFile(targetFile, COPY_TEST_OVERWRITE_TEXT);
        }
        FileUtils.integrateDirectory((File)MERGE_TEST_SOURCE_DIR, (File)MERGE_TEST_TARGET_DIR, (boolean)false);
        for (File targetFile : MERGE_TEST_EXPECTED_TARGET_FILES) {
            Assert.assertTrue((String)"The method integrateDirectory() should merge all directories and files to a target directory!", (boolean)targetFile.exists());
        }
    }

    private void assertDirectoryIntegration(boolean replaceFiles) {
        DiskIO diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        for (File sourceFile : MERGE_TEST_SOURCE_FILES) {
            diskIo.writeStringToFile(sourceFile, COPY_TEST_TEXT);
        }
        for (File targetFile : MERGE_TEST_TARGET_FILES) {
            diskIo.writeStringToFile(targetFile, COPY_TEST_OVERWRITE_TEXT);
        }
        FileUtils.integrateDirectory((File)MERGE_TEST_SOURCE_DIR, (File)MERGE_TEST_TARGET_DIR, (boolean)replaceFiles);
        File possiblyReplacedFile = (File)MERGE_TEST_TARGET_FILES.get(0);
        String expectedFileContent = replaceFiles ? COPY_TEST_TEXT : COPY_TEST_OVERWRITE_TEXT;
        Assert.assertEquals((String)"The method integrateDirectory() should merge all files to the target directory!", (Object)expectedFileContent, (Object)diskIo.getString(possiblyReplacedFile));
    }
}

