/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.utils;

import com.google.gson.Gson;
import de.gerdiproject.AbstractFileSystemUnitTest;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.utils.examples.diskio.MockedObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class DiskIOTest
extends AbstractFileSystemUnitTest<DiskIO> {
    private static final String TEST_STRING = "D\u00f6ner macht sch\u00f6ner!";
    private static final int OBJECT_TEST_INT = 1337;
    private static final String OBJECT_TEST_STRING = "Test String in Map";
    private final File testStringFile;
    private final File testObjectFile;

    public DiskIOTest() {
        this.testStringFile = new File(this.testFolder, "testDiskIoString.json");
        this.testObjectFile = new File(this.testFolder, "testDiskIoObject.json");
    }

    protected DiskIO setUpTestObjects() {
        return new DiskIO(new Gson(), StandardCharsets.UTF_8);
    }

    @Test
    public void testCharsets() {
        ((DiskIO)this.testedObject).writeStringToFile(this.testStringFile, TEST_STRING);
        String retrievedUtf8 = ((DiskIO)this.testedObject).getString(this.testStringFile);
        DiskIO diskIoAscii = new DiskIO(new Gson(), StandardCharsets.US_ASCII);
        String retrievedAscii = diskIoAscii.getString(this.testStringFile);
        Assert.assertNotEquals((String)"Reading 'D\u00f6ner macht sch\u00f6ner!' in different charsets should result in different strings!", (Object)retrievedUtf8, (Object)retrievedAscii);
    }

    @Test
    public void testWritingStrings() {
        ((DiskIO)this.testedObject).writeStringToFile(this.testStringFile, TEST_STRING);
        Assert.assertTrue((String)"The method writeStringToFile() should create a new file!", (boolean)this.testStringFile.exists());
    }

    @Test
    public void testReadingStrings() {
        ((DiskIO)this.testedObject).writeStringToFile(this.testStringFile, TEST_STRING);
        Assert.assertEquals((String)"The method getString() should return the same string that was written in writeStringToFile()!", (Object)((DiskIO)this.testedObject).getString(this.testStringFile), (Object)TEST_STRING);
    }

    @Test
    public void testOverwritingStrings() {
        ((DiskIO)this.testedObject).writeStringToFile(this.testStringFile, TEST_STRING);
        String firstReadString = ((DiskIO)this.testedObject).getString(this.testStringFile);
        ((DiskIO)this.testedObject).writeStringToFile(this.testStringFile, TEST_STRING);
        String secondReadString = ((DiskIO)this.testedObject).getString(this.testStringFile);
        Assert.assertEquals((String)"Calling writeStringToFile() multiple times should simply overwrite the file content!", (Object)firstReadString, (Object)secondReadString);
    }

    @Test
    public void testWritingObjects() {
        MockedObject testObject = new MockedObject(OBJECT_TEST_STRING, 1337);
        ((DiskIO)this.testedObject).writeObjectToFile(this.testObjectFile, (Object)testObject);
        Assert.assertTrue((String)"The method writeObjectToFile() should create a new file!", (boolean)this.testObjectFile.exists());
    }

    @Test
    public void testReadingObjects() {
        MockedObject testObject = new MockedObject(OBJECT_TEST_STRING, 1337);
        ((DiskIO)this.testedObject).writeObjectToFile(this.testObjectFile, (Object)testObject);
        MockedObject readObject = (MockedObject)((DiskIO)this.testedObject).getObject(this.testObjectFile, testObject.getClass());
        Assert.assertEquals((String)"The method getObject() should return the same string that was written in writeObjectToFile()!", (Object)readObject, (Object)testObject);
    }

    @Test
    public void testOverwritingObjects() {
        MockedObject writtenObject = new MockedObject(OBJECT_TEST_STRING, 1337);
        ((DiskIO)this.testedObject).writeObjectToFile(this.testObjectFile, (Object)writtenObject);
        MockedObject firstReadObject = (MockedObject)((DiskIO)this.testedObject).getObject(this.testObjectFile, writtenObject.getClass());
        ((DiskIO)this.testedObject).writeObjectToFile(this.testObjectFile, (Object)writtenObject);
        MockedObject secondReadObject = (MockedObject)((DiskIO)this.testedObject).getObject(this.testObjectFile, writtenObject.getClass());
        Assert.assertEquals((String)"Calling writeObjectToFile() multiple times should simply overwrite the file content!", (Object)firstReadObject, (Object)secondReadObject);
    }
}

